/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.client;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.cloud.nacos.NacosPropertySourceRepository;
import com.alibaba.cloud.nacos.client.NacosPropertySource;
import com.alibaba.cloud.nacos.client.NacosPropertySourceBuilder;
import com.alibaba.cloud.nacos.parser.NacosDataParserHandler;
import com.alibaba.cloud.nacos.refresh.NacosContextRefresher;
import com.alibaba.nacos.api.config.ConfigService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.CollectionUtils;

@Order(value=0)
public class NacosPropertySourceLocator
implements PropertySourceLocator {
    private static final Logger log = LoggerFactory.getLogger(NacosPropertySourceLocator.class);
    private static final String NACOS_PROPERTY_SOURCE_NAME = "NACOS";
    private static final String SEP1 = "-";
    private static final String DOT = ".";
    private NacosPropertySourceBuilder nacosPropertySourceBuilder;
    private NacosConfigProperties nacosConfigProperties;
    private NacosConfigManager nacosConfigManager;

    @Deprecated
    public NacosPropertySourceLocator(NacosConfigProperties nacosConfigProperties) {
        this.nacosConfigProperties = nacosConfigProperties;
    }

    public NacosPropertySourceLocator(NacosConfigManager nacosConfigManager) {
        this.nacosConfigManager = nacosConfigManager;
        this.nacosConfigProperties = nacosConfigManager.getNacosConfigProperties();
    }

    public PropertySource<?> locate(Environment environment) {
        this.nacosConfigProperties.setEnvironment(environment);
        ConfigService configService = this.nacosConfigManager.getConfigService();
        if (null == configService) {
            log.warn("no instance of config service found, can't load config from nacos");
            return null;
        }
        long l = this.nacosConfigProperties.getTimeout();
        this.nacosPropertySourceBuilder = new NacosPropertySourceBuilder(configService, l);
        String string = this.nacosConfigProperties.getName();
        String string2 = this.nacosConfigProperties.getPrefix();
        if (StringUtils.isEmpty((CharSequence)string2)) {
            string2 = string;
        }
        if (StringUtils.isEmpty((CharSequence)string2)) {
            string2 = environment.getProperty("spring.application.name");
        }
        CompositePropertySource compositePropertySource = new CompositePropertySource(NACOS_PROPERTY_SOURCE_NAME);
        this.loadSharedConfiguration(compositePropertySource);
        this.loadExtConfiguration(compositePropertySource);
        this.loadApplicationConfiguration(compositePropertySource, string2, this.nacosConfigProperties, environment);
        return compositePropertySource;
    }

    private void loadSharedConfiguration(CompositePropertySource compositePropertySource) {
        List<NacosConfigProperties.Config> list = this.nacosConfigProperties.getSharedConfigs();
        if (!CollectionUtils.isEmpty(list)) {
            this.checkConfiguration(list, "shared-configs");
            this.loadNacosConfiguration(compositePropertySource, list);
        }
    }

    private void loadExtConfiguration(CompositePropertySource compositePropertySource) {
        List<NacosConfigProperties.Config> list = this.nacosConfigProperties.getExtensionConfigs();
        if (!CollectionUtils.isEmpty(list)) {
            this.checkConfiguration(list, "extension-configs");
            this.loadNacosConfiguration(compositePropertySource, list);
        }
    }

    private void loadApplicationConfiguration(CompositePropertySource compositePropertySource, String string, NacosConfigProperties nacosConfigProperties, Environment environment) {
        String string2 = nacosConfigProperties.getFileExtension();
        String string3 = nacosConfigProperties.getGroup();
        this.loadNacosDataIfPresent(compositePropertySource, string, string3, string2, true);
        this.loadNacosDataIfPresent(compositePropertySource, string + DOT + string2, string3, string2, true);
        for (String string4 : environment.getActiveProfiles()) {
            String string5 = string + SEP1 + string4 + DOT + string2;
            this.loadNacosDataIfPresent(compositePropertySource, string5, string3, string2, true);
        }
    }

    private void loadNacosConfiguration(CompositePropertySource compositePropertySource, List<NacosConfigProperties.Config> list) {
        for (NacosConfigProperties.Config config : list) {
            this.loadNacosDataIfPresent(compositePropertySource, config.getDataId(), config.getGroup(), NacosDataParserHandler.getInstance().getFileExtension(config.getDataId()), config.isRefresh());
        }
    }

    private void checkConfiguration(List<NacosConfigProperties.Config> list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i).getDataId();
            if (string2 != null && string2.trim().length() != 0) continue;
            throw new IllegalStateException(String.format("the [ spring.cloud.nacos.config.%s[%s] ] must give a dataId", string, i));
        }
    }

    private void loadNacosDataIfPresent(CompositePropertySource compositePropertySource, String string, String string2, String string3, boolean bl) {
        if (null == string || string.trim().length() < 1) {
            return;
        }
        if (null == string2 || string2.trim().length() < 1) {
            return;
        }
        NacosPropertySource nacosPropertySource = this.loadNacosPropertySource(string, string2, string3, bl);
        this.addFirstPropertySource(compositePropertySource, nacosPropertySource, false);
    }

    private NacosPropertySource loadNacosPropertySource(String string, String string2, String string3, boolean bl) {
        if (NacosContextRefresher.getRefreshCount() != 0L && !bl) {
            return NacosPropertySourceRepository.getNacosPropertySource(string, string2);
        }
        return this.nacosPropertySourceBuilder.build(string, string2, string3, bl);
    }

    private void addFirstPropertySource(CompositePropertySource compositePropertySource, NacosPropertySource nacosPropertySource, boolean bl) {
        if (null == nacosPropertySource || null == compositePropertySource) {
            return;
        }
        if (bl && ((Map)nacosPropertySource.getSource()).isEmpty()) {
            return;
        }
        compositePropertySource.addFirstPropertySource((PropertySource)nacosPropertySource);
    }

    public void setNacosConfigManager(NacosConfigManager nacosConfigManager) {
        this.nacosConfigManager = nacosConfigManager;
    }
}

