/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.configdata;

import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.cloud.nacos.NacosPropertySourceRepository;
import com.alibaba.cloud.nacos.client.NacosPropertySource;
import com.alibaba.cloud.nacos.configdata.ConfigPreference;
import com.alibaba.cloud.nacos.configdata.NacosConfigDataResource;
import com.alibaba.cloud.nacos.parser.NacosDataParserHandler;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.env.PropertySource;

public class NacosConfigDataLoader
implements ConfigDataLoader<NacosConfigDataResource> {
    private final Log log;

    public NacosConfigDataLoader(DeferredLogFactory deferredLogFactory) {
        this.log = deferredLogFactory.getLog(this.getClass());
    }

    public ConfigData load(ConfigDataLoaderContext configDataLoaderContext, NacosConfigDataResource nacosConfigDataResource) {
        return this.doLoad(configDataLoaderContext, nacosConfigDataResource);
    }

    public ConfigData doLoad(ConfigDataLoaderContext configDataLoaderContext, NacosConfigDataResource nacosConfigDataResource) {
        try {
            ConfigService configService = this.getBean(configDataLoaderContext, NacosConfigManager.class).getConfigService();
            NacosConfigProperties nacosConfigProperties = this.getBean(configDataLoaderContext, NacosConfigProperties.class);
            NacosConfigDataResource.NacosItemConfig nacosItemConfig = nacosConfigDataResource.getConfig();
            List<PropertySource<?>> list = this.pullConfig(configService, nacosItemConfig.getGroup(), nacosItemConfig.getDataId(), nacosItemConfig.getSuffix(), nacosConfigProperties.getTimeout());
            NacosPropertySource nacosPropertySource = new NacosPropertySource(list, nacosItemConfig.getGroup(), nacosItemConfig.getDataId(), new Date(), nacosItemConfig.isRefreshEnabled());
            NacosPropertySourceRepository.collectNacosPropertySource(nacosPropertySource);
            return new ConfigData(list, this.getOptions(configDataLoaderContext, nacosConfigDataResource));
        }
        catch (Exception exception) {
            this.log.error((Object)("Error getting properties from nacos: " + nacosConfigDataResource), (Throwable)exception);
            if (!nacosConfigDataResource.isOptional()) {
                throw new ConfigDataResourceNotFoundException((ConfigDataResource)nacosConfigDataResource, (Throwable)exception);
            }
            return null;
        }
    }

    private ConfigData.Option[] getOptions(ConfigDataLoaderContext configDataLoaderContext, NacosConfigDataResource nacosConfigDataResource) {
        ArrayList<ConfigData.Option> arrayList = new ArrayList<ConfigData.Option>();
        arrayList.add(ConfigData.Option.IGNORE_IMPORTS);
        arrayList.add(ConfigData.Option.IGNORE_PROFILES);
        if (this.getPreference(configDataLoaderContext, nacosConfigDataResource) == ConfigPreference.REMOTE) {
            arrayList.add(ConfigData.Option.PROFILE_SPECIFIC);
        }
        return arrayList.toArray(new ConfigData.Option[0]);
    }

    private ConfigPreference getPreference(ConfigDataLoaderContext configDataLoaderContext, NacosConfigDataResource nacosConfigDataResource) {
        Binder binder = (Binder)configDataLoaderContext.getBootstrapContext().get(Binder.class);
        ConfigPreference configPreference = (ConfigPreference)((Object)binder.bind("spring.cloud.nacos.config.preference", ConfigPreference.class).orElse((Object)ConfigPreference.LOCAL));
        String string = nacosConfigDataResource.getConfig().getPreference();
        if (string != null) {
            try {
                configPreference = ConfigPreference.valueOf(string.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.error((Object)String.format("illegal preference value: %s, using default preference: %s", new Object[]{string, configPreference}));
            }
        }
        return configPreference;
    }

    private List<PropertySource<?>> pullConfig(ConfigService configService, String string, String string2, String string3, long l) throws NacosException, IOException {
        String string4 = configService.getConfig(string2, string, l);
        this.logLoadInfo(string, string2, string4);
        String string5 = string + "@" + string2;
        return NacosDataParserHandler.getInstance().parseNacosData(string5, string4, string3);
    }

    private void logLoadInfo(String string, String string2, String string3) {
        if (string3 != null) {
            this.log.info((Object)String.format("[Nacos Config] Load config[dataId=%s, group=%s] success", string2, string));
        } else {
            this.log.warn((Object)String.format("[Nacos Config] config[dataId=%s, group=%s] is empty", string2, string));
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("[Nacos Config] config[dataId=%s, group=%s] content: \n%s", string2, string, string3));
        }
    }

    protected <T> T getBean(ConfigDataLoaderContext configDataLoaderContext, Class<T> clazz) {
        if (configDataLoaderContext.getBootstrapContext().isRegistered(clazz)) {
            return (T)configDataLoaderContext.getBootstrapContext().get(clazz);
        }
        return null;
    }
}

