/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.configdata;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.cloud.nacos.configdata.NacosConfigDataLoadProperties;
import com.alibaba.cloud.nacos.configdata.NacosConfigDataResource;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.config.Profiles;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public class NacosConfigDataLocationResolver
implements ConfigDataLocationResolver<NacosConfigDataResource>,
Ordered {
    public static final String PREFIX = "nacos:";
    private static final String GROUP = "group";
    private static final String REFRESH_ENABLED = "refreshEnabled";
    private static final String PREFERENCE = "preference";
    private final Log log;
    private final ConfigurableEnvironment environment;

    public NacosConfigDataLocationResolver(DeferredLogFactory deferredLogFactory, ConfigurableEnvironment configurableEnvironment) {
        this.log = deferredLogFactory.getLog(this.getClass());
        this.environment = configurableEnvironment;
    }

    public int getOrder() {
        return -1;
    }

    protected NacosConfigProperties loadProperties(ConfigDataLocationResolverContext configDataLocationResolverContext) {
        Binder binder = configDataLocationResolverContext.getBinder();
        BindHandler bindHandler = this.getBindHandler(configDataLocationResolverContext);
        NacosConfigProperties nacosConfigProperties = configDataLocationResolverContext.getBootstrapContext().isRegistered(NacosConfigDataLoadProperties.class) ? (NacosConfigProperties)configDataLocationResolverContext.getBootstrapContext().get(NacosConfigDataLoadProperties.class) : (NacosConfigProperties)binder.bind("spring.cloud.nacos", Bindable.of(NacosConfigDataLoadProperties.class), bindHandler).map(nacosConfigDataLoadProperties -> (NacosConfigDataLoadProperties)binder.bind("spring.cloud.nacos.config", Bindable.ofInstance((Object)nacosConfigDataLoadProperties), bindHandler).orElse(nacosConfigDataLoadProperties)).orElseGet(() -> (NacosConfigDataLoadProperties)binder.bind("spring.cloud.nacos.config", Bindable.of(NacosConfigDataLoadProperties.class), bindHandler).orElseGet(NacosConfigDataLoadProperties::new));
        return nacosConfigProperties;
    }

    private BindHandler getBindHandler(ConfigDataLocationResolverContext configDataLocationResolverContext) {
        return (BindHandler)configDataLocationResolverContext.getBootstrapContext().getOrElse(BindHandler.class, null);
    }

    protected Log getLog() {
        return this.log;
    }

    public boolean isResolvable(ConfigDataLocationResolverContext configDataLocationResolverContext, ConfigDataLocation configDataLocation) {
        if (!configDataLocation.hasPrefix(this.getPrefix())) {
            return false;
        }
        return (Boolean)configDataLocationResolverContext.getBinder().bind("spring.cloud.nacos.config.enabled", Boolean.class).orElse((Object)true);
    }

    protected String getPrefix() {
        return PREFIX;
    }

    public List<NacosConfigDataResource> resolve(ConfigDataLocationResolverContext configDataLocationResolverContext, ConfigDataLocation configDataLocation) throws ConfigDataLocationNotFoundException, ConfigDataResourceNotFoundException {
        return Collections.emptyList();
    }

    public List<NacosConfigDataResource> resolveProfileSpecific(ConfigDataLocationResolverContext configDataLocationResolverContext, ConfigDataLocation configDataLocation, Profiles profiles) throws ConfigDataLocationNotFoundException {
        NacosConfigProperties nacosConfigProperties = this.loadProperties(configDataLocationResolverContext);
        ConfigurableBootstrapContext configurableBootstrapContext = configDataLocationResolverContext.getBootstrapContext();
        configurableBootstrapContext.registerIfAbsent(NacosConfigProperties.class, BootstrapRegistry.InstanceSupplier.of((Object)nacosConfigProperties));
        this.registerConfigManager(nacosConfigProperties, configurableBootstrapContext);
        return this.loadConfigDataResources(configDataLocation, profiles, nacosConfigProperties);
    }

    private List<NacosConfigDataResource> loadConfigDataResources(ConfigDataLocation configDataLocation, Profiles profiles, NacosConfigProperties nacosConfigProperties) {
        ArrayList<NacosConfigDataResource> arrayList = new ArrayList<NacosConfigDataResource>();
        URI uRI = this.getUri(configDataLocation, nacosConfigProperties);
        if (StringUtils.isBlank((CharSequence)this.dataIdFor(uRI))) {
            throw new IllegalArgumentException("dataId must be specified");
        }
        NacosConfigDataResource nacosConfigDataResource = new NacosConfigDataResource(nacosConfigProperties, configDataLocation.isOptional(), profiles, this.log, new NacosConfigDataResource.NacosItemConfig().setGroup(this.groupFor(uRI, nacosConfigProperties)).setDataId(this.dataIdFor(uRI)).setSuffix(this.suffixFor(uRI, nacosConfigProperties)).setRefreshEnabled(this.refreshEnabledFor(uRI, nacosConfigProperties)).setPreference(this.preferenceFor(uRI)));
        arrayList.add(nacosConfigDataResource);
        return arrayList;
    }

    private String preferenceFor(URI uRI) {
        return this.getQueryMap(uRI).get(PREFERENCE);
    }

    private URI getUri(ConfigDataLocation configDataLocation, NacosConfigProperties nacosConfigProperties) {
        Object object = configDataLocation.getNonPrefixedValue(this.getPrefix());
        if (StringUtils.isBlank((CharSequence)object)) {
            object = "/";
        }
        if (!((String)object).startsWith("/")) {
            object = "/" + (String)object;
        }
        String string = nacosConfigProperties.getServerAddr() + (String)object;
        return this.getUri(string);
    }

    private void registerConfigManager(NacosConfigProperties nacosConfigProperties, ConfigurableBootstrapContext configurableBootstrapContext) {
        if (!configurableBootstrapContext.isRegistered(NacosConfigManager.class)) {
            configurableBootstrapContext.register(NacosConfigManager.class, BootstrapRegistry.InstanceSupplier.of((Object)new NacosConfigManager(nacosConfigProperties, this.environment)));
        }
    }

    private URI getUri(String object) {
        URI uRI;
        if (!((String)object).startsWith("http://") && !((String)object).startsWith("https://")) {
            object = "http://" + (String)object;
        }
        try {
            uRI = new URI((String)object);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("illegal URI: " + (String)object);
        }
        return uRI;
    }

    private String groupFor(URI uRI, NacosConfigProperties nacosConfigProperties) {
        Map<String, String> map = this.getQueryMap(uRI);
        return map.containsKey(GROUP) ? map.get(GROUP) : nacosConfigProperties.getGroup();
    }

    private Map<String, String> getQueryMap(URI uRI) {
        String string = uRI.getQuery();
        if (StringUtils.isBlank((CharSequence)string)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        for (String string2 : string.split("&")) {
            String[] stringArray = string2.split("=");
            if (stringArray.length != 2) continue;
            hashMap.put(stringArray[0], stringArray[1]);
        }
        return hashMap;
    }

    private String suffixFor(URI uRI, NacosConfigProperties nacosConfigProperties) {
        String string = this.dataIdFor(uRI);
        if (string != null && string.contains(".")) {
            return string.substring(string.lastIndexOf(46) + 1);
        }
        return nacosConfigProperties.getFileExtension();
    }

    private boolean refreshEnabledFor(URI uRI, NacosConfigProperties nacosConfigProperties) {
        Map<String, String> map = this.getQueryMap(uRI);
        return map.containsKey(REFRESH_ENABLED) ? Boolean.parseBoolean(map.get(REFRESH_ENABLED)) : nacosConfigProperties.isRefreshEnabled();
    }

    private String dataIdFor(URI uRI) {
        String string = uRI.getPath();
        if (string == null || string.length() <= 1) {
            return "";
        }
        String[] stringArray = string.substring(1).split("/");
        if (stringArray.length != 1) {
            throw new IllegalArgumentException("illegal dataId");
        }
        return stringArray[0];
    }
}

