/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.configdata;

import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.cloud.commons.ConfigDataMissingEnvironmentPostProcessor;
import org.springframework.cloud.util.PropertyUtils;
import org.springframework.core.env.Environment;

public class NacosConfigDataMissingEnvironmentPostProcessor
extends ConfigDataMissingEnvironmentPostProcessor {
    public static final int ORDER = -2147482638;

    public int getOrder() {
        return -2147482638;
    }

    protected boolean shouldProcessEnvironment(Environment environment) {
        if (PropertyUtils.bootstrapEnabled((Environment)environment) || PropertyUtils.useLegacyProcessing((Environment)environment)) {
            return false;
        }
        boolean bl = (Boolean)environment.getProperty("spring.cloud.nacos.config.enabled", Boolean.class, (Object)true);
        boolean bl2 = (Boolean)environment.getProperty("spring.cloud.nacos.config.import-check.enabled", Boolean.class, (Object)true);
        return bl && bl2;
    }

    protected String getPrefix() {
        return "nacos:";
    }

    static class ImportExceptionFailureAnalyzer
    extends AbstractFailureAnalyzer<ConfigDataMissingEnvironmentPostProcessor.ImportException> {
        ImportExceptionFailureAnalyzer() {
        }

        protected FailureAnalysis analyze(Throwable throwable, ConfigDataMissingEnvironmentPostProcessor.ImportException importException) {
            String string = importException.missingPrefix ? "The spring.config.import property is missing a nacos: entry" : "No spring.config.import property has been defined";
            String string2 = "Add a spring.config.import=nacos: property to your configuration.\n\tIf configuration is not required add spring.config.import=optional:nacos: instead.\n\tTo disable this check, set spring.cloud.nacos.config.import-check.enabled=false.";
            return new FailureAnalysis(string, string2, (Throwable)importException);
        }
    }
}

