/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.configdata;

import com.alibaba.cloud.nacos.NacosConfigProperties;
import java.util.List;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.config.ConfigDataResource;
import org.springframework.boot.context.config.Profiles;
import org.springframework.util.StringUtils;

public class NacosConfigDataResource
extends ConfigDataResource {
    private final NacosConfigProperties properties;
    private final boolean optional;
    private final Profiles profiles;
    private final Log log;
    private final NacosItemConfig config;

    public NacosConfigDataResource(NacosConfigProperties nacosConfigProperties, boolean bl, Profiles profiles, Log log, NacosItemConfig nacosItemConfig) {
        this.properties = nacosConfigProperties;
        this.optional = bl;
        this.profiles = profiles;
        this.log = log;
        this.config = nacosItemConfig;
    }

    public NacosConfigProperties getProperties() {
        return this.properties;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String getProfiles() {
        return StringUtils.collectionToCommaDelimitedString(this.getAcceptedProfiles());
    }

    List<String> getAcceptedProfiles() {
        return this.profiles.getAccepted();
    }

    public Log getLog() {
        return this.log;
    }

    public NacosItemConfig getConfig() {
        return this.config;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        NacosConfigDataResource nacosConfigDataResource = (NacosConfigDataResource)((Object)object);
        return this.optional == nacosConfigDataResource.optional && Objects.equals(this.properties, nacosConfigDataResource.properties) && Objects.equals(this.profiles, nacosConfigDataResource.profiles) && Objects.equals(this.log, nacosConfigDataResource.log) && Objects.equals(this.config, nacosConfigDataResource.config);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.optional, this.profiles, this.log, this.config);
    }

    public String toString() {
        return "NacosConfigDataResource{properties=" + this.properties + ", optional=" + this.optional + ", profiles=" + this.profiles + ", config=" + this.config + "}";
    }

    public static class NacosItemConfig {
        private String group;
        private String dataId;
        private String suffix;
        private boolean refreshEnabled;
        private String preference;

        public NacosItemConfig() {
        }

        public NacosItemConfig(String string, String string2, String string3, boolean bl, String string4) {
            this.group = string;
            this.dataId = string2;
            this.suffix = string3;
            this.refreshEnabled = bl;
            this.preference = string4;
        }

        public NacosItemConfig setGroup(String string) {
            this.group = string;
            return this;
        }

        public NacosItemConfig setDataId(String string) {
            this.dataId = string;
            return this;
        }

        public NacosItemConfig setSuffix(String string) {
            this.suffix = string;
            return this;
        }

        public NacosItemConfig setRefreshEnabled(boolean bl) {
            this.refreshEnabled = bl;
            return this;
        }

        public NacosItemConfig setPreference(String string) {
            this.preference = string;
            return this;
        }

        public String getGroup() {
            return this.group;
        }

        public String getDataId() {
            return this.dataId;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public boolean isRefreshEnabled() {
            return this.refreshEnabled;
        }

        public String getPreference() {
            return this.preference;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            NacosItemConfig nacosItemConfig = (NacosItemConfig)object;
            return this.refreshEnabled == nacosItemConfig.refreshEnabled && Objects.equals(this.group, nacosItemConfig.group) && Objects.equals(this.dataId, nacosItemConfig.dataId) && Objects.equals(this.suffix, nacosItemConfig.suffix) && Objects.equals(this.preference, nacosItemConfig.preference);
        }

        public int hashCode() {
            return Objects.hash(this.group, this.dataId, this.suffix, this.refreshEnabled, this.preference);
        }

        public String toString() {
            return "NacosItemConfig{group='" + this.group + "', dataId='" + this.dataId + "', suffix='" + this.suffix + "', refreshEnabled=" + this.refreshEnabled + ", preference=" + this.preference + "}";
        }
    }
}

