/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.endpoint;

import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.cloud.nacos.NacosPropertySourceRepository;
import com.alibaba.cloud.nacos.client.NacosPropertySource;
import com.alibaba.cloud.nacos.refresh.NacosRefreshHistory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="nacosconfig")
public class NacosConfigEndpoint {
    private final NacosConfigProperties properties;
    private final NacosRefreshHistory refreshHistory;
    private ThreadLocal<DateFormat> dateFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));

    public NacosConfigEndpoint(NacosConfigProperties nacosConfigProperties, NacosRefreshHistory nacosRefreshHistory) {
        this.properties = nacosConfigProperties;
        this.refreshHistory = nacosRefreshHistory;
    }

    @ReadOperation
    public Map<String, Object> invoke() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(16);
        hashMap.put("NacosConfigProperties", this.properties);
        List<NacosPropertySource> list = NacosPropertySourceRepository.getAll();
        ArrayList arrayList = new ArrayList();
        for (NacosPropertySource nacosPropertySource : list) {
            HashMap<String, String> hashMap2 = new HashMap<String, String>(16);
            hashMap2.put("dataId", nacosPropertySource.getDataId());
            hashMap2.put("lastSynced", this.dateFormat.get().format(nacosPropertySource.getTimestamp()));
            arrayList.add(hashMap2);
        }
        hashMap.put("Sources", arrayList);
        hashMap.put("RefreshHistory", this.refreshHistory.getRecords());
        return hashMap;
    }
}

