/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.parser;

import com.alibaba.cloud.nacos.parser.NacosByteArrayResource;
import com.alibaba.cloud.nacos.utils.NacosConfigUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.boot.env.PropertiesPropertySourceLoader;
import org.springframework.boot.env.PropertySourceLoader;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class NacosDataParserHandler {
    private static final String DEFAULT_EXTENSION = "properties";
    private static List<PropertySourceLoader> propertySourceLoaders;

    private NacosDataParserHandler() {
        propertySourceLoaders = SpringFactoriesLoader.loadFactories(PropertySourceLoader.class, (ClassLoader)this.getClass().getClassLoader());
    }

    public List<PropertySource<?>> parseNacosData(String string, String string2, String string3) throws IOException {
        if (!StringUtils.hasLength((String)string2)) {
            return Collections.emptyList();
        }
        if (!StringUtils.hasLength((String)string3)) {
            string3 = this.getFileExtension(string);
        }
        for (PropertySourceLoader propertySourceLoader : propertySourceLoaders) {
            if (!this.canLoadFileExtension(propertySourceLoader, string3)) continue;
            NacosByteArrayResource nacosByteArrayResource = propertySourceLoader instanceof PropertiesPropertySourceLoader ? new NacosByteArrayResource(NacosConfigUtils.selectiveConvertUnicode(string2).getBytes(), string) : new NacosByteArrayResource(string2.getBytes(), string);
            nacosByteArrayResource.setFilename(this.getFileName(string, string3));
            List list = propertySourceLoader.load(string, (Resource)nacosByteArrayResource);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return Collections.emptyList();
            }
            return list.stream().filter(Objects::nonNull).map(propertySource -> {
                EnumerablePropertySource enumerablePropertySource;
                String[] stringArray;
                if (propertySource instanceof EnumerablePropertySource && (stringArray = (enumerablePropertySource = (EnumerablePropertySource)propertySource).getPropertyNames()) != null && stringArray.length > 0) {
                    LinkedHashMap linkedHashMap = new LinkedHashMap();
                    Arrays.stream(stringArray).forEach(string -> linkedHashMap.put(string, propertySource.getProperty(string)));
                    return new OriginTrackedMapPropertySource(propertySource.getName(), linkedHashMap, true);
                }
                return propertySource;
            }).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private boolean canLoadFileExtension(PropertySourceLoader propertySourceLoader, String string) {
        return Arrays.stream(propertySourceLoader.getFileExtensions()).anyMatch(string2 -> StringUtils.endsWithIgnoreCase((String)string, (String)string2));
    }

    public String getFileExtension(String string) {
        if (!StringUtils.hasLength((String)string)) {
            return DEFAULT_EXTENSION;
        }
        int n = string.lastIndexOf(".");
        if (n > 0 && n < string.length() - 1) {
            return string.substring(n + 1);
        }
        return DEFAULT_EXTENSION;
    }

    private String getFileName(String string, String string2) {
        String string3;
        if (!StringUtils.hasLength((String)string2)) {
            return string;
        }
        if (!StringUtils.hasLength((String)string)) {
            return string2;
        }
        int n = string.lastIndexOf(".");
        if (n > 0 && n < string.length() - 1 && string2.equalsIgnoreCase(string3 = string.substring(n + 1))) {
            return string;
        }
        return string + "." + string2;
    }

    public static NacosDataParserHandler getInstance() {
        return ParserHandler.HANDLER;
    }

    private static class ParserHandler {
        private static final NacosDataParserHandler HANDLER = new NacosDataParserHandler();

        private ParserHandler() {
        }
    }
}

