/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.parser;

import com.alibaba.cloud.nacos.parser.AbstractPropertySourceLoader;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;

public class NacosJsonPropertySourceLoader
extends AbstractPropertySourceLoader {
    private static final String VALUE = "value";

    public String[] getFileExtensions() {
        return new String[]{"json"};
    }

    @Override
    protected List<PropertySource<?>> doLoad(String string, Resource resource) throws IOException {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(32);
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        Map map = (Map)objectMapper.readValue(resource.getInputStream(), LinkedHashMap.class);
        this.flattenedMap(linkedHashMap, map, null);
        return Collections.singletonList(new OriginTrackedMapPropertySource(string, this.reloadMap(linkedHashMap), true));
    }

    protected Map<String, Object> reloadMap(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(map);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            int n;
            String string;
            String string2 = entry.getKey();
            if (!string2.contains(".") || !VALUE.equalsIgnoreCase(string = string2.substring((n = string2.lastIndexOf(".")) + 1))) continue;
            linkedHashMap.put(string2.substring(0, n), entry.getValue());
        }
        return linkedHashMap;
    }
}

