/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.parser;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.nacos.parser.AbstractPropertySourceLoader;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.core.Ordered;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NacosXmlPropertySourceLoader
extends AbstractPropertySourceLoader
implements Ordered {
    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public String[] getFileExtensions() {
        return new String[]{"xml"};
    }

    @Override
    protected List<PropertySource<?>> doLoad(String string, Resource resource) throws IOException {
        Map<String, Object> map = this.parseXml2Map(resource);
        return Collections.singletonList(new OriginTrackedMapPropertySource(string, map, true));
    }

    private Map<String, Object> parseXml2Map(Resource resource) throws IOException {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(32);
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(resource.getInputStream());
            if (null == document) {
                return null;
            }
            this.parseNodeList(document.getChildNodes(), linkedHashMap, "");
        }
        catch (Exception exception) {
            throw new IOException("The xml content parse error.", exception.getCause());
        }
        return linkedHashMap;
    }

    private void parseNodeList(NodeList nodeList, Map<String, Object> map, String string) {
        if (nodeList == null || nodeList.getLength() < 1) {
            return;
        }
        string = string == null ? "" : string;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string2 = node.getNodeValue();
            string2 = string2 == null ? "" : string2.trim();
            String string3 = node.getNodeName();
            String string4 = string3 = string3 == null ? "" : string3.trim();
            if (StringUtils.isEmpty((CharSequence)string3)) continue;
            String string5 = StringUtils.isEmpty((CharSequence)string) ? string3 : string + "." + string3;
            NamedNodeMap namedNodeMap = node.getAttributes();
            this.parseNodeAttr(namedNodeMap, map, string5);
            if (node.getNodeType() == 1 && node.hasChildNodes()) {
                this.parseNodeList(node.getChildNodes(), map, string5);
                continue;
            }
            if (string2.length() < 1) continue;
            map.put(string, string2);
        }
    }

    private void parseNodeAttr(NamedNodeMap namedNodeMap, Map<String, Object> map, String string) {
        if (null == namedNodeMap || namedNodeMap.getLength() < 1) {
            return;
        }
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            if (null == node || node.getNodeType() != 2 || StringUtils.isEmpty((CharSequence)node.getNodeName()) || StringUtils.isEmpty((CharSequence)node.getNodeValue())) continue;
            map.put(String.join((CharSequence)".", string, node.getNodeName()), node.getNodeValue());
        }
    }
}

