/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.refresh;

import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.cloud.nacos.NacosPropertySourceRepository;
import com.alibaba.cloud.nacos.client.NacosPropertySource;
import com.alibaba.cloud.nacos.refresh.NacosRefreshHistory;
import com.alibaba.cloud.nacos.refresh.NacosSnapshotConfigManager;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.AbstractSharedListener;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class NacosContextRefresher
implements ApplicationListener<ApplicationReadyEvent>,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(NacosContextRefresher.class);
    private static final AtomicLong REFRESH_COUNT = new AtomicLong(0L);
    private final boolean isRefreshEnabled;
    private final NacosRefreshHistory nacosRefreshHistory;
    private NacosConfigProperties nacosConfigProperties;
    private ConfigService configService;
    private NacosConfigManager configManager;
    private ApplicationContext applicationContext;
    private AtomicBoolean ready = new AtomicBoolean(false);
    private Map<String, Listener> listenerMap = new ConcurrentHashMap<String, Listener>(16);

    public NacosContextRefresher(NacosConfigManager nacosConfigManager, NacosRefreshHistory nacosRefreshHistory) {
        this.configManager = nacosConfigManager;
        this.nacosConfigProperties = nacosConfigManager.getNacosConfigProperties();
        this.nacosRefreshHistory = nacosRefreshHistory;
        this.isRefreshEnabled = this.nacosConfigProperties.isRefreshEnabled();
    }

    public static long getRefreshCount() {
        return REFRESH_COUNT.get();
    }

    public static void refreshCountIncrement() {
        REFRESH_COUNT.incrementAndGet();
    }

    public void onApplicationEvent(ApplicationReadyEvent applicationReadyEvent) {
        if (this.ready.compareAndSet(false, true)) {
            this.registerNacosListenersForApplications();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private void registerNacosListenersForApplications() {
        if (this.isRefreshEnabled()) {
            for (NacosPropertySource nacosPropertySource : NacosPropertySourceRepository.getAll()) {
                if (!nacosPropertySource.isRefreshable()) continue;
                String string = nacosPropertySource.getDataId();
                this.registerNacosListener(nacosPropertySource.getGroup(), string);
            }
        }
    }

    private void registerNacosListener(String string2, String string3) {
        String string4 = NacosPropertySourceRepository.getMapKey(string3, string2);
        Listener listener = this.listenerMap.computeIfAbsent(string4, string -> new AbstractSharedListener(){

            public void innerReceive(String string, String string2, String string3) {
                NacosContextRefresher.refreshCountIncrement();
                NacosContextRefresher.this.nacosRefreshHistory.addRefreshRecord(string, string2, string3);
                NacosSnapshotConfigManager.putConfigSnapshot(string, string2, string3);
                NacosContextRefresher.this.applicationContext.publishEvent((ApplicationEvent)new RefreshEvent((Object)this, null, "Refresh Nacos config"));
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Refresh Nacos config group=%s,dataId=%s,configInfo=%s", string2, string, string3));
                }
            }
        });
        try {
            if (this.configService == null && this.configManager != null) {
                this.configService = this.configManager.getConfigService();
            }
            this.configService.addListener(string3, string2, listener);
            log.info("[Nacos Config] Listening config: dataId={}, group={}", (Object)string3, (Object)string2);
        }
        catch (NacosException nacosException) {
            log.warn(String.format("register fail for nacos listener ,dataId=[%s],group=[%s]", string3, string2), (Throwable)nacosException);
        }
    }

    public NacosConfigProperties getNacosConfigProperties() {
        return this.nacosConfigProperties;
    }

    public NacosContextRefresher setNacosConfigProperties(NacosConfigProperties nacosConfigProperties) {
        this.nacosConfigProperties = nacosConfigProperties;
        return this;
    }

    public boolean isRefreshEnabled() {
        if (null == this.nacosConfigProperties) {
            return this.isRefreshEnabled;
        }
        if (this.nacosConfigProperties.isRefreshEnabled() && !this.isRefreshEnabled) {
            return false;
        }
        return this.isRefreshEnabled;
    }
}

