/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.refresh;

import com.alibaba.cloud.commons.lang.StringUtils;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosRefreshHistory {
    private static final Logger log = LoggerFactory.getLogger(NacosRefreshHistory.class);
    private static final int MAX_SIZE = 20;
    private final LinkedList<Record> records = new LinkedList();
    private final ThreadLocal<DateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    private MessageDigest md;

    public NacosRefreshHistory() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.error("failed to initialize MessageDigest : ", (Throwable)noSuchAlgorithmException);
        }
    }

    @Deprecated
    public void add(String string, String string2) {
        this.records.addFirst(new Record(this.DATE_FORMAT.get().format(new Date()), string, "", string2, null));
        if (this.records.size() > 20) {
            this.records.removeLast();
        }
    }

    public void addRefreshRecord(String string, String string2, String string3) {
        this.records.addFirst(new Record(this.DATE_FORMAT.get().format(new Date()), string, string2, this.md5(string3), null));
        if (this.records.size() > 20) {
            this.records.removeLast();
        }
    }

    public LinkedList<Record> getRecords() {
        return this.records;
    }

    private String md5(String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        if (null == this.md) {
            try {
                this.md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                return "unable to get md5";
            }
        }
        return new BigInteger(1, this.md.digest(string.getBytes(StandardCharsets.UTF_8))).toString(16);
    }

    static class Record {
        private final String timestamp;
        private final String dataId;
        private final String group;
        private final String md5;

        Record(String string, String string2, String string3, String string4, Map<String, Object> map) {
            this.timestamp = string;
            this.dataId = string2;
            this.group = string3;
            this.md5 = string4;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        public String getDataId() {
            return this.dataId;
        }

        public String getGroup() {
            return this.group;
        }

        public String getMd5() {
            return this.md5;
        }
    }
}

