/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.refresh;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NacosSnapshotConfigManager {
    private static final Logger log = LoggerFactory.getLogger(NacosSnapshotConfigManager.class);
    private static final Map<String, String> CONFIG_INFO_SNAPSHOT_MAP = new ConcurrentHashMap<String, String>(8);
    private static final int MAX_SNAPSHOT_COUNT = 100;

    private NacosSnapshotConfigManager() {
    }

    private static String formatConfigSnapshotKey(String string, String string2) {
        return string + "@" + string2;
    }

    public static String getAndRemoveConfigSnapshot(String string, String string2) {
        String string3 = CONFIG_INFO_SNAPSHOT_MAP.get(NacosSnapshotConfigManager.formatConfigSnapshotKey(string, string2));
        NacosSnapshotConfigManager.removeConfigSnapshot(string, string2);
        return string3;
    }

    public static void putConfigSnapshot(String string, String string2, String string3) {
        try {
            Object object;
            if (CONFIG_INFO_SNAPSHOT_MAP.size() > 100) {
                object = CONFIG_INFO_SNAPSHOT_MAP.entrySet().iterator();
                object.next();
                object.remove();
            }
            object = NacosSnapshotConfigManager.formatConfigSnapshotKey(string, string2);
            if (string3 == null) {
                CONFIG_INFO_SNAPSHOT_MAP.remove(object);
            } else {
                CONFIG_INFO_SNAPSHOT_MAP.put((String)object, string3);
            }
        }
        catch (Exception exception) {
            log.warn("remove nacos config snapshot error", (Throwable)exception);
        }
    }

    public static void removeConfigSnapshot(String string, String string2) {
        CONFIG_INFO_SNAPSHOT_MAP.remove(NacosSnapshotConfigManager.formatConfigSnapshotKey(string, string2));
    }
}

