/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.refresh;

import com.alibaba.cloud.nacos.refresh.RefreshBehavior;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.properties.ConfigurationPropertiesBean;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.cloud.context.properties.ConfigurationPropertiesBeans;
import org.springframework.cloud.context.properties.ConfigurationPropertiesRebinder;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class SmartConfigurationPropertiesRebinder
extends ConfigurationPropertiesRebinder {
    private Map<String, ConfigurationPropertiesBean> beanMap;
    private ApplicationContext applicationContext;
    private RefreshBehavior refreshBehavior;

    public SmartConfigurationPropertiesRebinder(ConfigurationPropertiesBeans configurationPropertiesBeans) {
        super(configurationPropertiesBeans);
        this.fillBeanMap(configurationPropertiesBeans);
    }

    private void fillBeanMap(ConfigurationPropertiesBeans configurationPropertiesBeans) {
        this.beanMap = new HashMap<String, ConfigurationPropertiesBean>();
        Field field = ReflectionUtils.findField(configurationPropertiesBeans.getClass(), (String)"beans");
        if (field != null) {
            field.setAccessible(true);
            this.beanMap.putAll(Optional.ofNullable(ReflectionUtils.getField((Field)field, (Object)configurationPropertiesBeans)).orElse(Collections.emptyMap()));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        this.applicationContext = applicationContext;
        this.refreshBehavior = (RefreshBehavior)((Object)this.applicationContext.getEnvironment().getProperty("spring.cloud.nacos.config.refresh-behavior", RefreshBehavior.class, (Object)RefreshBehavior.ALL_BEANS));
    }

    public void onApplicationEvent(EnvironmentChangeEvent environmentChangeEvent) {
        if (this.applicationContext.equals(environmentChangeEvent.getSource()) || environmentChangeEvent.getKeys().equals(environmentChangeEvent.getSource())) {
            switch (this.refreshBehavior) {
                case SPECIFIC_BEAN: {
                    this.rebindSpecificBean(environmentChangeEvent);
                    break;
                }
                default: {
                    this.rebind();
                }
            }
        }
    }

    private void rebindSpecificBean(EnvironmentChangeEvent environmentChangeEvent) {
        HashSet hashSet = new HashSet();
        this.beanMap.forEach((string, configurationPropertiesBean) -> environmentChangeEvent.getKeys().forEach(string2 -> {
            String string3 = AnnotationUtils.getValue((Annotation)configurationPropertiesBean.getAnnotation()).toString();
            if (string2.startsWith(string3) && hashSet.add(string)) {
                this.rebind((String)string);
            }
        }));
    }
}

