/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.cloud.nacos.event.NacosDiscoveryInfoChangedEvent;
import com.alibaba.cloud.nacos.util.InetIPv6Utils;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.spring.util.PropertySourcesUtils;
import jakarta.annotation.PostConstruct;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

@ConfigurationProperties(value="spring.cloud.nacos.discovery")
public class NacosDiscoveryProperties {
    public static final String PREFIX = "spring.cloud.nacos.discovery";
    private static final Logger log = LoggerFactory.getLogger(NacosDiscoveryProperties.class);
    private static final Pattern PATTERN = Pattern.compile("-(\\w)");
    private static final String IPV4 = "IPv4";
    private static final String IPV6 = "IPv6";
    private String serverAddr;
    private String username;
    private String password;
    private String endpoint;
    private String namespace;
    private long watchDelay = 30000L;
    private String logName;
    @Value(value="${spring.cloud.nacos.discovery.service:${spring.application.name:}}")
    private String service;
    private float weight = 1.0f;
    private String clusterName;
    private String group = "DEFAULT_GROUP";
    private String namingLoadCacheAtStart = "false";
    private Map<String, String> metadata = new HashMap<String, String>();
    private boolean registerEnabled = true;
    private String ip;
    private String networkInterface = "";
    private String ipType;
    private int port = -1;
    private boolean secure = false;
    private String accessKey;
    private String secretKey;
    private Integer heartBeatInterval;
    private Integer heartBeatTimeout;
    private Integer ipDeleteTimeout;
    private boolean instanceEnabled = true;
    private boolean ephemeral = true;
    private boolean failureToleranceEnabled;
    private boolean failFast = true;
    @Autowired
    private InetIPv6Utils inetIPv6Utils;
    @Autowired
    private InetUtils inetUtils;
    @Autowired
    private Environment environment;
    @Autowired
    private NacosServiceManager nacosServiceManager;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PostConstruct
    public void init() throws Exception {
        this.metadata.put("preserved.register.source", "SPRING_CLOUD");
        if (this.secure) {
            this.metadata.put("secure", "true");
        }
        this.serverAddr = Objects.toString(this.serverAddr, "");
        if (this.serverAddr.endsWith("/")) {
            this.serverAddr = this.serverAddr.substring(0, this.serverAddr.length() - 1);
        }
        this.endpoint = Objects.toString(this.endpoint, "");
        this.namespace = Objects.toString(this.namespace, "");
        this.logName = Objects.toString(this.logName, "");
        if (StringUtils.isEmpty((CharSequence)this.ip)) {
            if (StringUtils.isEmpty((CharSequence)this.networkInterface)) {
                if (this.ipType == null) {
                    this.ip = this.inetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
                    String string = this.inetIPv6Utils.findIPv6Address();
                    this.metadata.put(IPV6, string);
                    if (string != null) {
                        this.metadata.put(IPV6, string);
                    }
                } else if (IPV4.equalsIgnoreCase(this.ipType)) {
                    this.ip = this.inetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
                } else {
                    if (!IPV6.equalsIgnoreCase(this.ipType)) throw new IllegalArgumentException("please checking the type of IP " + this.ipType);
                    this.ip = this.inetIPv6Utils.findIPv6Address();
                    if (StringUtils.isEmpty((CharSequence)this.ip)) {
                        log.warn("There is no available IPv6 found. Spring Cloud Alibaba will automatically find IPv4.");
                        this.ip = this.inetUtils.findFirstNonLoopbackHostInfo().getIpAddress();
                    }
                }
            } else {
                NetworkInterface networkInterface = NetworkInterface.getByName(this.networkInterface);
                if (null == networkInterface) {
                    throw new IllegalArgumentException("no such interface " + this.networkInterface);
                }
                Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
                while (enumeration.hasMoreElements()) {
                    InetAddress inetAddress = enumeration.nextElement();
                    if (!(inetAddress instanceof Inet4Address) && (!(inetAddress instanceof Inet6Address) || inetAddress.isLoopbackAddress())) continue;
                    this.ip = inetAddress.getHostAddress();
                    break;
                }
                if (StringUtils.isEmpty((CharSequence)this.ip)) {
                    throw new RuntimeException("cannot find available ip from network interface " + this.networkInterface);
                }
            }
        }
        this.overrideFromEnv(this.environment);
        if (this.nacosServiceManager.isNacosDiscoveryInfoChanged(this)) {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new NacosDiscoveryInfoChangedEvent(this));
        }
        this.nacosServiceManager.setNacosDiscoveryProperties(this);
    }

    @Deprecated
    public NamingService namingServiceInstance() {
        return this.nacosServiceManager.getNamingService();
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String string) {
        this.endpoint = string;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String string) {
        this.logName = string;
    }

    public void setInetUtils(InetUtils inetUtils) {
        this.inetUtils = inetUtils;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float f) {
        this.weight = f;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String string) {
        this.clusterName = string;
    }

    public String getService() {
        return this.service;
    }

    public void setService(String string) {
        this.service = string;
    }

    public boolean isRegisterEnabled() {
        return this.registerEnabled;
    }

    public void setRegisterEnabled(boolean bl) {
        this.registerEnabled = bl;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String string) {
        this.ip = string;
    }

    public String getIpType() {
        return this.ipType;
    }

    public void setIpType(String string) {
        this.ipType = string;
    }

    public String getNetworkInterface() {
        return this.networkInterface;
    }

    public void setNetworkInterface(String string) {
        this.networkInterface = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, String> map) {
        this.metadata = map;
    }

    public String getServerAddr() {
        return this.serverAddr;
    }

    public void setServerAddr(String string) {
        this.serverAddr = string;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String string) {
        this.accessKey = string;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String string) {
        this.secretKey = string;
    }

    public Integer getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    public void setHeartBeatInterval(Integer n) {
        this.heartBeatInterval = n;
    }

    public Integer getHeartBeatTimeout() {
        return this.heartBeatTimeout;
    }

    public void setHeartBeatTimeout(Integer n) {
        this.heartBeatTimeout = n;
    }

    public Integer getIpDeleteTimeout() {
        return this.ipDeleteTimeout;
    }

    public void setIpDeleteTimeout(Integer n) {
        this.ipDeleteTimeout = n;
    }

    public String getNamingLoadCacheAtStart() {
        return this.namingLoadCacheAtStart;
    }

    public void setNamingLoadCacheAtStart(String string) {
        this.namingLoadCacheAtStart = string;
    }

    public long getWatchDelay() {
        return this.watchDelay;
    }

    public void setWatchDelay(long l) {
        this.watchDelay = l;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public boolean isInstanceEnabled() {
        return this.instanceEnabled;
    }

    public void setInstanceEnabled(boolean bl) {
        this.instanceEnabled = bl;
    }

    public boolean isEphemeral() {
        return this.ephemeral;
    }

    public void setEphemeral(boolean bl) {
        this.ephemeral = bl;
    }

    public boolean isFailureToleranceEnabled() {
        return this.failureToleranceEnabled;
    }

    public void setFailureToleranceEnabled(boolean bl) {
        this.failureToleranceEnabled = bl;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean bl) {
        this.failFast = bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NacosDiscoveryProperties nacosDiscoveryProperties = (NacosDiscoveryProperties)object;
        return this.watchDelay == nacosDiscoveryProperties.watchDelay && Float.compare(nacosDiscoveryProperties.weight, this.weight) == 0 && this.registerEnabled == nacosDiscoveryProperties.registerEnabled && this.port == nacosDiscoveryProperties.port && this.secure == nacosDiscoveryProperties.secure && this.instanceEnabled == nacosDiscoveryProperties.instanceEnabled && this.ephemeral == nacosDiscoveryProperties.ephemeral && this.failureToleranceEnabled == nacosDiscoveryProperties.failureToleranceEnabled && Objects.equals(this.serverAddr, nacosDiscoveryProperties.serverAddr) && Objects.equals(this.username, nacosDiscoveryProperties.username) && Objects.equals(this.password, nacosDiscoveryProperties.password) && Objects.equals(this.endpoint, nacosDiscoveryProperties.endpoint) && Objects.equals(this.namespace, nacosDiscoveryProperties.namespace) && Objects.equals(this.logName, nacosDiscoveryProperties.logName) && Objects.equals(this.service, nacosDiscoveryProperties.service) && Objects.equals(this.clusterName, nacosDiscoveryProperties.clusterName) && Objects.equals(this.group, nacosDiscoveryProperties.group) && Objects.equals(this.namingLoadCacheAtStart, nacosDiscoveryProperties.namingLoadCacheAtStart) && Objects.equals(this.metadata, nacosDiscoveryProperties.metadata) && Objects.equals(this.ip, nacosDiscoveryProperties.ip) && Objects.equals(this.networkInterface, nacosDiscoveryProperties.networkInterface) && Objects.equals(this.accessKey, nacosDiscoveryProperties.accessKey) && Objects.equals(this.secretKey, nacosDiscoveryProperties.secretKey) && Objects.equals(this.heartBeatInterval, nacosDiscoveryProperties.heartBeatInterval) && Objects.equals(this.heartBeatTimeout, nacosDiscoveryProperties.heartBeatTimeout) && Objects.equals(this.failFast, nacosDiscoveryProperties.failFast) && Objects.equals(this.ipDeleteTimeout, nacosDiscoveryProperties.ipDeleteTimeout);
    }

    public int hashCode() {
        return Objects.hash(this.serverAddr, this.username, this.password, this.endpoint, this.namespace, this.watchDelay, this.logName, this.service, Float.valueOf(this.weight), this.clusterName, this.group, this.namingLoadCacheAtStart, this.metadata, this.registerEnabled, this.ip, this.networkInterface, this.port, this.secure, this.accessKey, this.secretKey, this.heartBeatInterval, this.heartBeatTimeout, this.ipDeleteTimeout, this.instanceEnabled, this.ephemeral, this.failureToleranceEnabled, this.failFast);
    }

    public String toString() {
        return "NacosDiscoveryProperties{serverAddr='" + this.serverAddr + "', username='" + this.username + "', password='" + this.password + "', endpoint='" + this.endpoint + "', namespace='" + this.namespace + "', watchDelay=" + this.watchDelay + ", logName='" + this.logName + "', service='" + this.service + "', weight=" + this.weight + ", clusterName='" + this.clusterName + "', group='" + this.group + "', namingLoadCacheAtStart='" + this.namingLoadCacheAtStart + "', metadata=" + this.metadata + ", registerEnabled=" + this.registerEnabled + ", ip='" + this.ip + "', networkInterface='" + this.networkInterface + "', port=" + this.port + ", secure=" + this.secure + ", accessKey='" + this.accessKey + "', secretKey='" + this.secretKey + "', heartBeatInterval=" + this.heartBeatInterval + ", heartBeatTimeout=" + this.heartBeatTimeout + ", ipDeleteTimeout=" + this.ipDeleteTimeout + ", instanceEnabled=" + this.instanceEnabled + ", ephemeral=" + this.ephemeral + ", failureToleranceEnabled=" + this.failureToleranceEnabled + "}, ipDeleteTimeout=" + this.ipDeleteTimeout + ", failFast=" + this.failFast + "}";
    }

    public void overrideFromEnv(Environment environment) {
        if (StringUtils.isEmpty((CharSequence)this.getServerAddr())) {
            String string = environment.resolvePlaceholders("${spring.cloud.nacos.discovery.server-addr:}");
            if (StringUtils.isEmpty((CharSequence)string)) {
                string = environment.resolvePlaceholders("${spring.cloud.nacos.server-addr:127.0.0.1:8848}");
            }
            this.setServerAddr(string);
        }
        if (StringUtils.isEmpty((CharSequence)this.getNamespace())) {
            this.setNamespace(environment.resolvePlaceholders("${spring.cloud.nacos.discovery.namespace:}"));
        }
        if (StringUtils.isEmpty((CharSequence)this.getAccessKey())) {
            this.setAccessKey(environment.resolvePlaceholders("${spring.cloud.nacos.discovery.access-key:}"));
        }
        if (StringUtils.isEmpty((CharSequence)this.getSecretKey())) {
            this.setSecretKey(environment.resolvePlaceholders("${spring.cloud.nacos.discovery.secret-key:}"));
        }
        if (StringUtils.isEmpty((CharSequence)this.getLogName())) {
            this.setLogName(environment.resolvePlaceholders("${spring.cloud.nacos.discovery.log-name:}"));
        }
        if (StringUtils.isEmpty((CharSequence)this.getClusterName())) {
            this.setClusterName(environment.resolvePlaceholders("${spring.cloud.nacos.discovery.cluster-name:}"));
        }
        if (StringUtils.isEmpty((CharSequence)this.getEndpoint())) {
            this.setEndpoint(environment.resolvePlaceholders("${spring.cloud.nacos.discovery.endpoint:}"));
        }
        if (StringUtils.isEmpty((CharSequence)this.getGroup())) {
            this.setGroup(environment.resolvePlaceholders("${spring.cloud.nacos.discovery.group:}"));
        }
        if (StringUtils.isEmpty((CharSequence)this.getUsername())) {
            this.setUsername(environment.resolvePlaceholders("${spring.cloud.nacos.username:}"));
        }
        if (StringUtils.isEmpty((CharSequence)this.getPassword())) {
            this.setPassword(environment.resolvePlaceholders("${spring.cloud.nacos.password:}"));
        }
    }

    public Properties getNacosProperties() {
        Properties properties = new Properties();
        properties.put("serverAddr", this.serverAddr);
        properties.put("username", Objects.toString(this.username, ""));
        properties.put("password", Objects.toString(this.password, ""));
        properties.put("namespace", this.namespace);
        properties.put("com.alibaba.nacos.naming.log.filename", this.logName);
        if (this.endpoint.contains(":")) {
            int n = this.endpoint.indexOf(":");
            properties.put("endpoint", this.endpoint.substring(0, n));
            properties.put("endpointPort", this.endpoint.substring(n + 1));
        } else {
            properties.put("endpoint", this.endpoint);
        }
        properties.put("accessKey", this.accessKey);
        properties.put("secretKey", this.secretKey);
        properties.put("namingLoadCacheAtStart", this.namingLoadCacheAtStart);
        this.enrichNacosDiscoveryProperties(properties);
        return properties;
    }

    private void enrichNacosDiscoveryProperties(Properties properties) {
        Map map = PropertySourcesUtils.getSubProperties((ConfigurableEnvironment)((ConfigurableEnvironment)this.environment), (String)PREFIX);
        map.forEach((string, object) -> properties.putIfAbsent(this.resolveKey((String)string), String.valueOf(object)));
    }

    private String resolveKey(String string) {
        Matcher matcher = PATTERN.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }
}

