/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos;

import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;

public class NacosServiceInstance
implements ServiceInstance {
    private String serviceId;
    private String instanceId;
    private String host;
    private int port;
    private boolean secure;
    private Map<String, String> metadata;

    public String getServiceId() {
        return this.serviceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public URI getUri() {
        return DefaultServiceInstance.getUri((ServiceInstance)this);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getScheme() {
        return this.getUri().getScheme();
    }

    public void setServiceId(String string) {
        this.serviceId = string;
    }

    public void setInstanceId(String string) {
        this.instanceId = string;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setSecure(boolean bl) {
        this.secure = bl;
    }

    public void setMetadata(Map<String, String> map) {
        this.metadata = map;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NacosServiceInstance nacosServiceInstance = (NacosServiceInstance)object;
        return Objects.equals(this.serviceId, nacosServiceInstance.serviceId) && Objects.equals(this.instanceId, nacosServiceInstance.instanceId) && Objects.equals(this.host, nacosServiceInstance.host) && this.port == nacosServiceInstance.port && this.secure == nacosServiceInstance.secure && Objects.equals(this.metadata, nacosServiceInstance.metadata);
    }

    public int hashCode() {
        return this.instanceId == null ? 31 : this.instanceId.hashCode() + 31;
    }
}

