/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingMaintainService;
import com.alibaba.nacos.api.naming.NamingService;
import com.lenovo.cloud.framework.jasypt.constant.JasyptConstants;
import com.lenovo.cloud.framework.jasypt.util.JasyptNacosUtils;
import com.lenovo.cloud.framework.jasypt.util.JasyptUtils;
import java.util.Objects;
import java.util.Properties;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;

public class NacosServiceManager {
    private static final Logger log = LoggerFactory.getLogger(NacosServiceManager.class);
    private NacosDiscoveryProperties nacosDiscoveryProperties;
    private volatile NamingService namingService;
    private volatile NamingMaintainService namingMaintainService;
    private volatile ConfigurableEnvironment environment;

    public NamingService getNamingService() {
        if (Objects.isNull(this.namingService)) {
            NacosDiscoveryProperties nacosDiscoveryProperties = new NacosDiscoveryProperties();
            StandardPBEStringEncryptor standardPBEStringEncryptor = JasyptUtils.getEncryptorFromEnvironment((ConfigurableEnvironment)this.environment);
            if (standardPBEStringEncryptor != null) {
                JasyptNacosUtils.processEnvironment((ConfigurableEnvironment)this.environment, (StandardPBEStringEncryptor)standardPBEStringEncryptor);
                this.setNacosPropertiesFromSystemProperties(nacosDiscoveryProperties);
            }
            this.buildNamingService(this.nacosDiscoveryProperties.getNacosProperties());
        }
        return this.namingService;
    }

    @Deprecated
    public NamingService getNamingService(Properties properties) {
        if (Objects.isNull(this.namingService)) {
            this.buildNamingService(properties);
        }
        return this.namingService;
    }

    public NamingMaintainService getNamingMaintainService(Properties properties) {
        if (Objects.isNull(this.namingMaintainService)) {
            this.buildNamingMaintainService(properties);
        }
        return this.namingMaintainService;
    }

    public boolean isNacosDiscoveryInfoChanged(NacosDiscoveryProperties nacosDiscoveryProperties) {
        return !Objects.isNull(this.nacosDiscoveryProperties) && !this.nacosDiscoveryProperties.equals(nacosDiscoveryProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NamingMaintainService buildNamingMaintainService(Properties properties) {
        if (!Objects.isNull(this.namingMaintainService)) return this.namingMaintainService;
        Class<NacosServiceManager> clazz = NacosServiceManager.class;
        synchronized (NacosServiceManager.class) {
            if (!Objects.isNull(this.namingMaintainService)) return this.namingMaintainService;
            this.namingMaintainService = this.createNamingMaintainService(properties);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.namingMaintainService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NamingService buildNamingService(Properties properties) {
        if (!Objects.isNull(this.namingService)) return this.namingService;
        Class<NacosServiceManager> clazz = NacosServiceManager.class;
        synchronized (NacosServiceManager.class) {
            if (!Objects.isNull(this.namingService)) return this.namingService;
            this.namingService = this.createNewNamingService(properties);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.namingService;
        }
    }

    private NamingService createNewNamingService(Properties properties) {
        try {
            return NacosFactory.createNamingService((Properties)properties);
        }
        catch (NacosException nacosException) {
            throw new RuntimeException(nacosException);
        }
    }

    private NamingMaintainService createNamingMaintainService(Properties properties) {
        try {
            return NacosFactory.createMaintainService((Properties)properties);
        }
        catch (NacosException nacosException) {
            throw new RuntimeException(nacosException);
        }
    }

    public void nacosServiceShutDown() throws NacosException {
        if (Objects.nonNull(this.namingService)) {
            this.namingService.shutDown();
            this.namingService = null;
        }
        if (Objects.nonNull(this.namingMaintainService)) {
            this.namingMaintainService.shutDown();
            this.namingMaintainService = null;
        }
    }

    public void setNacosDiscoveryProperties(NacosDiscoveryProperties nacosDiscoveryProperties) {
        this.nacosDiscoveryProperties = nacosDiscoveryProperties;
    }

    private void setNacosPropertiesFromSystemProperties(NacosDiscoveryProperties nacosDiscoveryProperties) {
        for (String string : JasyptConstants.NACOS_PROPERTY_PREFIXES) {
            String string2 = System.getProperty(string);
            if (string2 == null || string2.isEmpty()) continue;
            if (string.endsWith("username")) {
                nacosDiscoveryProperties.setUsername(string2);
                continue;
            }
            if (!string.endsWith("password")) continue;
            nacosDiscoveryProperties.setPassword(string2);
        }
    }
}

