/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.balancer;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.nacos.NacosServiceInstance;
import com.alibaba.cloud.nacos.loadbalancer.NacosLoadBalancer;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.client.naming.core.Balancer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.cloud.client.ServiceInstance;

public class NacosBalancer
extends Balancer {
    private static final String IPV4_REGEX = "((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})(.((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})){3}";
    private static final String IPV6_KEY = "IPv6";

    public static Instance getHostByRandomWeight2(List<Instance> list) {
        return NacosBalancer.getHostByRandomWeight(list);
    }

    public static ServiceInstance getHostByRandomWeight3(List<ServiceInstance> list) {
        HashMap hashMap = new HashMap();
        List<Instance> list2 = list.stream().map(serviceInstance -> {
            Map map2 = serviceInstance.getMetadata();
            Instance instance = new Instance();
            instance.setIp(serviceInstance.getHost());
            instance.setPort(serviceInstance.getPort());
            instance.setWeight(Double.parseDouble((String)map2.get("nacos.weight")));
            instance.setHealthy(Boolean.parseBoolean((String)map2.get("nacos.healthy")));
            hashMap.put(instance, serviceInstance);
            return instance;
        }).collect(Collectors.toList());
        Instance instance = NacosBalancer.getHostByRandomWeight2(list2);
        NacosServiceInstance nacosServiceInstance = (NacosServiceInstance)hashMap.get(instance);
        if (StringUtils.isNotEmpty((CharSequence)NacosLoadBalancer.ipv6)) {
            NacosBalancer.convertIPv4ToIPv6(nacosServiceInstance);
        }
        return nacosServiceInstance;
    }

    private static void convertIPv4ToIPv6(NacosServiceInstance nacosServiceInstance) {
        String string;
        if (Pattern.matches(IPV4_REGEX, nacosServiceInstance.getHost()) && StringUtils.isNotEmpty((CharSequence)(string = nacosServiceInstance.getMetadata().get(IPV6_KEY)))) {
            nacosServiceInstance.setHost(string);
        }
    }
}

