/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.discovery;

import com.alibaba.cloud.nacos.discovery.NacosServiceDiscovery;
import com.alibaba.cloud.nacos.discovery.ServiceCache;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class NacosDiscoveryClient
implements DiscoveryClient {
    private static final Logger log = LoggerFactory.getLogger(NacosDiscoveryClient.class);
    public static final String DESCRIPTION = "Spring Cloud Nacos Discovery Client";
    private NacosServiceDiscovery serviceDiscovery;
    @Value(value="${spring.cloud.nacos.discovery.failure-tolerance-enabled:false}")
    private boolean failureToleranceEnabled;

    public NacosDiscoveryClient(NacosServiceDiscovery nacosServiceDiscovery) {
        this.serviceDiscovery = nacosServiceDiscovery;
    }

    public String description() {
        return DESCRIPTION;
    }

    public List<ServiceInstance> getInstances(String string) {
        try {
            return Optional.of(this.serviceDiscovery.getInstances(string)).map(list -> {
                ServiceCache.setInstances(string, list);
                return list;
            }).get();
        }
        catch (Exception exception) {
            if (this.failureToleranceEnabled) {
                return ServiceCache.getInstances(string);
            }
            throw new RuntimeException("Can not get hosts from nacos server. serviceId: " + string, exception);
        }
    }

    public List<String> getServices() {
        try {
            return Optional.of(this.serviceDiscovery.getServices()).map(list -> {
                ServiceCache.setServiceIds(list);
                return list;
            }).get();
        }
        catch (Exception exception) {
            log.error("get service name from nacos server failed.", (Throwable)exception);
            return this.failureToleranceEnabled ? ServiceCache.getServiceIds() : Collections.emptyList();
        }
    }
}

