/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.discovery;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceInstance;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.cloud.client.ServiceInstance;

public class NacosServiceDiscovery {
    private NacosDiscoveryProperties discoveryProperties;
    private NacosServiceManager nacosServiceManager;

    public NacosServiceDiscovery(NacosDiscoveryProperties nacosDiscoveryProperties, NacosServiceManager nacosServiceManager) {
        this.discoveryProperties = nacosDiscoveryProperties;
        this.nacosServiceManager = nacosServiceManager;
    }

    public List<ServiceInstance> getInstances(String string) throws NacosException {
        String string2 = this.discoveryProperties.getGroup();
        List list = this.namingService().selectInstances(string, string2, true);
        return NacosServiceDiscovery.hostToServiceInstanceList(list, string);
    }

    public List<String> getServices() throws NacosException {
        String string = this.discoveryProperties.getGroup();
        ListView listView = this.namingService().getServicesOfServer(1, Integer.MAX_VALUE, string);
        return listView.getData();
    }

    public static List<ServiceInstance> hostToServiceInstanceList(List<Instance> list, String string) {
        ArrayList<ServiceInstance> arrayList = new ArrayList<ServiceInstance>(list.size());
        for (Instance instance : list) {
            ServiceInstance serviceInstance = NacosServiceDiscovery.hostToServiceInstance(instance, string);
            if (serviceInstance == null) continue;
            arrayList.add(serviceInstance);
        }
        return arrayList;
    }

    public static ServiceInstance hostToServiceInstance(Instance instance, String string) {
        if (instance == null || !instance.isEnabled() || !instance.isHealthy()) {
            return null;
        }
        NacosServiceInstance nacosServiceInstance = new NacosServiceInstance();
        nacosServiceInstance.setHost(instance.getIp());
        nacosServiceInstance.setPort(instance.getPort());
        nacosServiceInstance.setServiceId(string);
        nacosServiceInstance.setInstanceId(instance.getInstanceId());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("nacos.instanceId", instance.getInstanceId());
        hashMap.put("nacos.weight", "" + instance.getWeight());
        hashMap.put("nacos.healthy", "" + instance.isHealthy());
        hashMap.put("nacos.cluster", instance.getClusterName());
        if (instance.getMetadata() != null) {
            hashMap.putAll(instance.getMetadata());
        }
        hashMap.put("nacos.ephemeral", String.valueOf(instance.isEphemeral()));
        nacosServiceInstance.setMetadata(hashMap);
        if (hashMap.containsKey("secure")) {
            boolean bl = Boolean.parseBoolean((String)hashMap.get("secure"));
            nacosServiceInstance.setSecure(bl);
        }
        return nacosServiceInstance;
    }

    private NamingService namingService() {
        return this.nacosServiceManager.getNamingService();
    }
}

