/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.discovery;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.Event;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.SmartLifecycle;

public class NacosWatch
implements SmartLifecycle,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(NacosWatch.class);
    private final Map<String, EventListener> listenerMap = new ConcurrentHashMap<String, EventListener>(16);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final NacosServiceManager nacosServiceManager;
    private final NacosDiscoveryProperties properties;

    public NacosWatch(NacosServiceManager nacosServiceManager, NacosDiscoveryProperties nacosDiscoveryProperties) {
        this.nacosServiceManager = nacosServiceManager;
        this.properties = nacosDiscoveryProperties;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable runnable) {
        this.stop();
        runnable.run();
    }

    public void start() {
        if (this.running.compareAndSet(false, true)) {
            EventListener eventListener = this.listenerMap.computeIfAbsent(this.buildKey(), string -> new EventListener(){

                public void onEvent(Event event) {
                    if (event instanceof NamingEvent) {
                        NamingEvent namingEvent = (NamingEvent)event;
                        List list = namingEvent.getInstances();
                        Optional<Instance> optional = NacosWatch.this.selectCurrentInstance(list);
                        optional.ifPresent(instance -> NacosWatch.this.resetIfNeeded((Instance)instance));
                    }
                }
            });
            NamingService namingService = this.nacosServiceManager.getNamingService();
            try {
                namingService.subscribe(this.properties.getService(), this.properties.getGroup(), Arrays.asList(this.properties.getClusterName()), eventListener);
            }
            catch (Exception exception) {
                log.error("namingService subscribe failed, properties:{}", (Object)this.properties, (Object)exception);
            }
        }
    }

    private String buildKey() {
        return String.join((CharSequence)":", this.properties.getService(), this.properties.getGroup());
    }

    private void resetIfNeeded(Instance instance) {
        if (!this.properties.getMetadata().equals(instance.getMetadata())) {
            this.properties.setMetadata(instance.getMetadata());
        }
    }

    private Optional<Instance> selectCurrentInstance(List<Instance> list) {
        return list.stream().filter(instance -> this.properties.getIp().equals(instance.getIp()) && this.properties.getPort() == instance.getPort()).findFirst();
    }

    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            EventListener eventListener = this.listenerMap.get(this.buildKey());
            try {
                NamingService namingService = this.nacosServiceManager.getNamingService();
                namingService.unsubscribe(this.properties.getService(), this.properties.getGroup(), Arrays.asList(this.properties.getClusterName()), eventListener);
            }
            catch (Exception exception) {
                log.error("namingService unsubscribe failed, properties:{}", (Object)this.properties, (Object)exception);
            }
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public int getPhase() {
        return 0;
    }

    public void destroy() {
        this.stop();
    }
}

