/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.discovery.configclient;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import jakarta.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties
@ConditionalOnClass(value={NacosDiscoveryProperties.class, ConfigServerProperties.class})
public class NacosConfigServerAutoConfiguration {
    @Autowired(required=false)
    private NacosDiscoveryProperties properties;
    @Autowired(required=false)
    private ConfigServerProperties server;

    @PostConstruct
    public void init() {
        if (this.properties == null || this.server == null) {
            return;
        }
        String string = this.server.getPrefix();
        if (StringUtils.hasText((String)string) && !StringUtils.hasText((String)this.properties.getMetadata().get("configPath"))) {
            this.properties.getMetadata().put("configPath", string);
        }
    }
}

