/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.endpoint;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

@Endpoint(id="nacosdiscovery")
public class NacosDiscoveryEndpoint {
    private static final Logger log = LoggerFactory.getLogger(NacosDiscoveryEndpoint.class);
    private NacosServiceManager nacosServiceManager;
    private NacosDiscoveryProperties nacosDiscoveryProperties;

    public NacosDiscoveryEndpoint(NacosServiceManager nacosServiceManager, NacosDiscoveryProperties nacosDiscoveryProperties) {
        this.nacosServiceManager = nacosServiceManager;
        this.nacosDiscoveryProperties = nacosDiscoveryProperties;
    }

    @ReadOperation
    public Map<String, Object> nacosDiscovery() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("NacosDiscoveryProperties", this.nacosDiscoveryProperties);
        NamingService namingService = this.nacosServiceManager.getNamingService();
        List list = Collections.emptyList();
        try {
            list = namingService.getSubscribeServices();
            for (ServiceInfo serviceInfo : list) {
                List list2 = namingService.getAllInstances(serviceInfo.getName(), serviceInfo.getGroupName());
                serviceInfo.setHosts(list2);
            }
        }
        catch (Exception exception) {
            log.error("get subscribe services from nacos fail,", (Throwable)exception);
        }
        hashMap.put("subscribe", list);
        return hashMap;
    }
}

