/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.loadbalancer;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.balancer.NacosBalancer;
import com.alibaba.cloud.nacos.util.InetIPv6Utils;
import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.loadbalancer.core.NoopServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ReactorServiceInstanceLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import reactor.core.publisher.Mono;

public class NacosLoadBalancer
implements ReactorServiceInstanceLoadBalancer {
    private static final Logger log = LoggerFactory.getLogger(NacosLoadBalancer.class);
    private final String serviceId;
    private ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider;
    private final NacosDiscoveryProperties nacosDiscoveryProperties;
    private static final String IPV4_REGEX = "((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})(.((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})){3}";
    private static final String IPV6_KEY = "IPv6";
    public static String ipv6;
    @Autowired
    private InetIPv6Utils inetIPv6Utils;

    @PostConstruct
    public void init() {
        String string = this.nacosDiscoveryProperties.getIp();
        ipv6 = StringUtils.isNotEmpty((CharSequence)string) ? (Pattern.matches(IPV4_REGEX, string) ? this.nacosDiscoveryProperties.getMetadata().get(IPV6_KEY) : string) : this.inetIPv6Utils.findIPv6Address();
    }

    private List<ServiceInstance> filterInstanceByIpType(List<ServiceInstance> list) {
        if (StringUtils.isNotEmpty((CharSequence)ipv6)) {
            ArrayList<ServiceInstance> arrayList = new ArrayList<ServiceInstance>();
            for (ServiceInstance serviceInstance2 : list) {
                if (Pattern.matches(IPV4_REGEX, serviceInstance2.getHost())) {
                    if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)serviceInstance2.getMetadata().get(IPV6_KEY)))) continue;
                    arrayList.add(serviceInstance2);
                    continue;
                }
                arrayList.add(serviceInstance2);
            }
            if (arrayList.size() == 0) {
                return list.stream().filter(serviceInstance -> Pattern.matches(IPV4_REGEX, serviceInstance.getHost())).collect(Collectors.toList());
            }
            return arrayList;
        }
        return list.stream().filter(serviceInstance -> Pattern.matches(IPV4_REGEX, serviceInstance.getHost())).collect(Collectors.toList());
    }

    public NacosLoadBalancer(ObjectProvider<ServiceInstanceListSupplier> objectProvider, String string, NacosDiscoveryProperties nacosDiscoveryProperties) {
        this.serviceId = string;
        this.serviceInstanceListSupplierProvider = objectProvider;
        this.nacosDiscoveryProperties = nacosDiscoveryProperties;
    }

    public Mono<Response<ServiceInstance>> choose(Request request) {
        ServiceInstanceListSupplier serviceInstanceListSupplier = (ServiceInstanceListSupplier)this.serviceInstanceListSupplierProvider.getIfAvailable(NoopServiceInstanceListSupplier::new);
        return serviceInstanceListSupplier.get(request).next().map(this::getInstanceResponse);
    }

    private Response<ServiceInstance> getInstanceResponse(List<ServiceInstance> list) {
        if (list.isEmpty()) {
            log.warn("No servers available for service: " + this.serviceId);
            return new EmptyResponse();
        }
        try {
            ServiceInstance serviceInstance2;
            String string = this.nacosDiscoveryProperties.getClusterName();
            List<Object> list2 = list;
            if (StringUtils.isNotBlank((CharSequence)string)) {
                serviceInstance2 = list.stream().filter(serviceInstance -> {
                    String string2 = (String)serviceInstance.getMetadata().get("nacos.cluster");
                    return StringUtils.equals((CharSequence)string2, (CharSequence)string);
                }).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(serviceInstance2)) {
                    list2 = serviceInstance2;
                }
            } else {
                log.warn("A cross-cluster call occurs\uff0cname = {}, clusterName = {}, instance = {}", new Object[]{this.serviceId, string, list});
            }
            list2 = this.filterInstanceByIpType(list2);
            serviceInstance2 = NacosBalancer.getHostByRandomWeight3(list2);
            return new DefaultResponse(serviceInstance2);
        }
        catch (Exception exception) {
            log.warn("NacosLoadBalancer error", (Throwable)exception);
            return null;
        }
    }
}

