/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.registry;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.registry.NacosRegistrationCustomizer;
import jakarta.annotation.PostConstruct;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ManagementServerPortUtils;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class NacosRegistration
implements Registration {
    public static final String MANAGEMENT_PORT = "management.port";
    public static final String MANAGEMENT_CONTEXT_PATH = "management.context-path";
    public static final String MANAGEMENT_ADDRESS = "management.address";
    public static final String MANAGEMENT_ENDPOINT_BASE_PATH = "management.endpoints.web.base-path";
    private List<NacosRegistrationCustomizer> registrationCustomizers;
    private NacosDiscoveryProperties nacosDiscoveryProperties;
    private ApplicationContext context;

    public NacosRegistration(List<NacosRegistrationCustomizer> list, NacosDiscoveryProperties nacosDiscoveryProperties, ApplicationContext applicationContext) {
        this.registrationCustomizers = list;
        this.nacosDiscoveryProperties = nacosDiscoveryProperties;
        this.context = applicationContext;
    }

    @PostConstruct
    public void init() {
        Integer n;
        Map<String, String> map = this.nacosDiscoveryProperties.getMetadata();
        Environment environment = this.context.getEnvironment();
        String string = environment.getProperty(MANAGEMENT_ENDPOINT_BASE_PATH);
        if (StringUtils.hasLength((String)string)) {
            map.put(MANAGEMENT_ENDPOINT_BASE_PATH, string);
        }
        if (null != (n = ManagementServerPortUtils.getPort((BeanFactory)this.context))) {
            map.put(MANAGEMENT_PORT, n.toString());
            String string2 = environment.getProperty("management.server.servlet.context-path");
            String string3 = environment.getProperty("management.server.address");
            if (StringUtils.hasLength((String)string2)) {
                map.put(MANAGEMENT_CONTEXT_PATH, string2);
            }
            if (StringUtils.hasLength((String)string3)) {
                map.put(MANAGEMENT_ADDRESS, string3);
            }
        }
        if (null != this.nacosDiscoveryProperties.getHeartBeatInterval()) {
            map.put("preserved.heart.beat.interval", this.nacosDiscoveryProperties.getHeartBeatInterval().toString());
        }
        if (null != this.nacosDiscoveryProperties.getHeartBeatTimeout()) {
            map.put("preserved.heart.beat.timeout", this.nacosDiscoveryProperties.getHeartBeatTimeout().toString());
        }
        if (null != this.nacosDiscoveryProperties.getIpDeleteTimeout()) {
            map.put("preserved.ip.delete.timeout", this.nacosDiscoveryProperties.getIpDeleteTimeout().toString());
        }
        this.customize(this.registrationCustomizers);
    }

    protected void customize(List<NacosRegistrationCustomizer> list) {
        if (list != null) {
            for (NacosRegistrationCustomizer nacosRegistrationCustomizer : list) {
                nacosRegistrationCustomizer.customize(this);
            }
        }
    }

    public String getServiceId() {
        return this.nacosDiscoveryProperties.getService();
    }

    public String getHost() {
        return this.nacosDiscoveryProperties.getIp();
    }

    public int getPort() {
        return this.nacosDiscoveryProperties.getPort();
    }

    public void setPort(int n) {
        this.nacosDiscoveryProperties.setPort(n);
    }

    public boolean isSecure() {
        return this.nacosDiscoveryProperties.isSecure();
    }

    public URI getUri() {
        return DefaultServiceInstance.getUri((ServiceInstance)this);
    }

    public Map<String, String> getMetadata() {
        return this.nacosDiscoveryProperties.getMetadata();
    }

    public boolean isRegisterEnabled() {
        return this.nacosDiscoveryProperties.isRegisterEnabled();
    }

    public String getCluster() {
        return this.nacosDiscoveryProperties.getClusterName();
    }

    public float getRegisterWeight() {
        return this.nacosDiscoveryProperties.getWeight();
    }

    public NacosDiscoveryProperties getNacosDiscoveryProperties() {
        return this.nacosDiscoveryProperties;
    }

    public String toString() {
        return "NacosRegistration{nacosDiscoveryProperties=" + this.nacosDiscoveryProperties + "}";
    }
}

