/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.registry;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.util.ReflectionUtils;

public class NacosServiceRegistry
implements ServiceRegistry<Registration> {
    private static final String STATUS_UP = "UP";
    private static final String STATUS_DOWN = "DOWN";
    private static final Logger log = LoggerFactory.getLogger(NacosServiceRegistry.class);
    private final NacosDiscoveryProperties nacosDiscoveryProperties;
    private final NacosServiceManager nacosServiceManager;

    public NacosServiceRegistry(NacosServiceManager nacosServiceManager, NacosDiscoveryProperties nacosDiscoveryProperties) {
        this.nacosDiscoveryProperties = nacosDiscoveryProperties;
        this.nacosServiceManager = nacosServiceManager;
    }

    public void register(Registration registration) {
        if (StringUtils.isEmpty((CharSequence)registration.getServiceId())) {
            log.warn("No service to register for nacos client...");
            return;
        }
        NamingService namingService = this.namingService();
        String string = registration.getServiceId();
        String string2 = this.nacosDiscoveryProperties.getGroup();
        Instance instance = this.getNacosInstanceFromRegistration(registration);
        try {
            namingService.registerInstance(string, string2, instance);
            log.info("nacos registry, {} {} {}:{} register finished", new Object[]{string2, string, instance.getIp(), instance.getPort()});
        }
        catch (Exception exception) {
            if (this.nacosDiscoveryProperties.isFailFast()) {
                log.error("nacos registry, {} register failed...{},", new Object[]{string, registration.toString(), exception});
                ReflectionUtils.rethrowRuntimeException((Throwable)exception);
            }
            log.warn("Failfast is false. {} register failed...{},", new Object[]{string, registration.toString(), exception});
        }
    }

    public void deregister(Registration registration) {
        log.info("De-registering from Nacos Server now...");
        if (StringUtils.isEmpty((CharSequence)registration.getServiceId())) {
            log.warn("No dom to de-register for nacos client...");
            return;
        }
        NamingService namingService = this.namingService();
        String string = registration.getServiceId();
        String string2 = this.nacosDiscoveryProperties.getGroup();
        try {
            namingService.deregisterInstance(string, string2, registration.getHost(), registration.getPort(), this.nacosDiscoveryProperties.getClusterName());
        }
        catch (Exception exception) {
            log.error("ERR_NACOS_DEREGISTER, de-register failed...{},", (Object)registration.toString(), (Object)exception);
        }
        log.info("De-registration finished.");
    }

    public void close() {
        try {
            this.nacosServiceManager.nacosServiceShutDown();
        }
        catch (NacosException nacosException) {
            log.error("Nacos namingService shutDown failed", (Throwable)nacosException);
        }
    }

    public void setStatus(Registration registration, String string) {
        if (!STATUS_UP.equalsIgnoreCase(string) && !STATUS_DOWN.equalsIgnoreCase(string)) {
            log.warn("can't support status {},please choose UP or DOWN", (Object)string);
            return;
        }
        String string2 = registration.getServiceId();
        Instance instance = this.getNacosInstanceFromRegistration(registration);
        if (STATUS_DOWN.equalsIgnoreCase(string)) {
            instance.setEnabled(false);
        } else {
            instance.setEnabled(true);
        }
        try {
            Properties properties = this.nacosDiscoveryProperties.getNacosProperties();
            this.nacosServiceManager.getNamingMaintainService(properties).updateInstance(string2, this.nacosDiscoveryProperties.getGroup(), instance);
        }
        catch (Exception exception) {
            throw new RuntimeException("update nacos instance status fail", exception);
        }
    }

    public Object getStatus(Registration registration) {
        String string = registration.getServiceId();
        String string2 = this.nacosDiscoveryProperties.getGroup();
        try {
            List list = this.namingService().getAllInstances(string, string2);
            for (Instance instance : list) {
                if (!instance.getIp().equalsIgnoreCase(this.nacosDiscoveryProperties.getIp()) || instance.getPort() != this.nacosDiscoveryProperties.getPort()) continue;
                return instance.isEnabled() ? STATUS_UP : STATUS_DOWN;
            }
        }
        catch (Exception exception) {
            log.error("get all instance of {} error,", (Object)string, (Object)exception);
        }
        return null;
    }

    private Instance getNacosInstanceFromRegistration(Registration registration) {
        Instance instance = new Instance();
        instance.setIp(registration.getHost());
        instance.setPort(registration.getPort());
        instance.setWeight((double)this.nacosDiscoveryProperties.getWeight());
        instance.setClusterName(this.nacosDiscoveryProperties.getClusterName());
        instance.setEnabled(this.nacosDiscoveryProperties.isInstanceEnabled());
        instance.setMetadata(registration.getMetadata());
        instance.setEphemeral(this.nacosDiscoveryProperties.isEphemeral());
        return instance;
    }

    private NamingService namingService() {
        return this.nacosServiceManager.getNamingService();
    }
}

