/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.nacos.util;

import com.alibaba.cloud.commons.lang.StringUtils;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.commons.util.InetUtilsProperties;

public class InetIPv6Utils {
    private static final Log log = LogFactory.getLog(InetIPv6Utils.class);
    private final InetUtilsProperties properties;

    public InetIPv6Utils(InetUtilsProperties inetUtilsProperties) {
        this.properties = inetUtilsProperties;
    }

    private InetUtils.HostInfo findFirstValidHostInfo() {
        InetAddress inetAddress = this.findFirstValidIPv6Address();
        return inetAddress != null ? this.getHostInfo(inetAddress) : null;
    }

    private InetAddress findFirstValidIPv6Address() {
        InetAddress inetAddress = null;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            block2: while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (!networkInterface.isUp() && networkInterface.isVirtual() && networkInterface.isLoopback()) continue;
                if (inetAddress == null) {
                    if (this.ignoreInterface(networkInterface.getDisplayName())) continue;
                    Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                    while (enumeration2.hasMoreElements()) {
                        InetAddress inetAddress2 = enumeration2.nextElement();
                        if (!(inetAddress2 instanceof Inet6Address) || inetAddress2.isLoopbackAddress() || inetAddress2.isLinkLocalAddress() || inetAddress2.isAnyLocalAddress() || inetAddress2.isSiteLocalAddress() || this.isUniqueLocalAddress(inetAddress2) || !this.isPreferredAddress(inetAddress2)) continue;
                        log.trace((Object)("Found non-loopback interface: " + networkInterface.getDisplayName()));
                        inetAddress = inetAddress2;
                        continue block2;
                    }
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            log.error((Object)"Cannot get first non-loopback address", (Throwable)iOException);
        }
        return inetAddress;
    }

    public String findIPv6Address() {
        InetUtils.HostInfo hostInfo = this.findFirstValidHostInfo();
        return hostInfo != null ? this.normalizeIPv6(hostInfo.getIpAddress()) : null;
    }

    private String normalizeIPv6(String string) {
        int n = string.indexOf("%");
        return n != -1 ? "[" + string.substring(0, n) + "]" : "[" + string + "]";
    }

    private boolean isPreferredAddress(InetAddress inetAddress) {
        if (this.properties.isUseOnlySiteLocalInterfaces()) {
            boolean bl = inetAddress.isSiteLocalAddress();
            if (!bl) {
                log.trace((Object)("Ignoring address" + inetAddress.getHostAddress()));
            }
            return bl;
        }
        List list = this.properties.getPreferredNetworks();
        if (list.isEmpty()) {
            return true;
        }
        for (String string : list) {
            String string2 = inetAddress.getHostAddress();
            if (!string2.matches(string) && !string2.startsWith(string)) continue;
            return true;
        }
        return false;
    }

    boolean ignoreInterface(String string) {
        for (String string2 : this.properties.getIgnoredInterfaces()) {
            if (!string.matches(string2)) continue;
            return true;
        }
        return false;
    }

    private InetUtils.HostInfo getHostInfo(InetAddress inetAddress) {
        InetUtils.HostInfo hostInfo = new InetUtils.HostInfo();
        String string = inetAddress.getHostName();
        if (string == null) {
            string = "localhost";
        }
        hostInfo.setHostname(string);
        if (StringUtils.isNotEmpty((CharSequence)inetAddress.getHostAddress())) {
            hostInfo.setIpAddress(inetAddress.getHostAddress());
        } else {
            hostInfo.setIpAddress("");
        }
        return hostInfo;
    }

    private boolean isUniqueLocalAddress(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        return (byArray[0] & 0xFF) == 253;
    }
}

