/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.datapermission.core.util;

import com.lenovo.cloud.framework.datapermission.core.annotation.DataPermission;
import com.lenovo.cloud.framework.datapermission.core.aop.DataPermissionContextHolder;
import java.util.concurrent.Callable;

public class DataPermissionUtils {
    private static DataPermission DATA_PERMISSION_DISABLE;

    @DataPermission(enable=false)
    private static DataPermission getDisableDataPermissionDisable() {
        if (DATA_PERMISSION_DISABLE == null) {
            DATA_PERMISSION_DISABLE = DataPermissionUtils.class.getDeclaredMethod("getDisableDataPermissionDisable", new Class[0]).getAnnotation(DataPermission.class);
        }
        return DATA_PERMISSION_DISABLE;
    }

    public static void executeIgnore(Runnable runnable) {
        DataPermission dataPermission = DataPermissionUtils.getDisableDataPermissionDisable();
        DataPermissionContextHolder.add(dataPermission);
        try {
            runnable.run();
        }
        finally {
            DataPermissionContextHolder.remove();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T executeIgnore(Callable<T> callable) {
        DataPermission dataPermission = DataPermissionUtils.getDisableDataPermissionDisable();
        DataPermissionContextHolder.add(dataPermission);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            DataPermissionContextHolder.remove();
        }
    }
}

