/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.ip.core.utils;

import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.csv.CsvRow;
import cn.hutool.core.text.csv.CsvUtil;
import com.lenovo.cloud.framework.common.util.collection.CollectionUtils;
import com.lenovo.cloud.framework.common.util.object.ObjectUtils;
import com.lenovo.cloud.framework.ip.core.Area;
import com.lenovo.cloud.framework.ip.core.enums.AreaTypeEnum;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AreaUtils.class);
    private static final AreaUtils INSTANCE = new AreaUtils();
    private static Map<Integer, Area> areas;

    private AreaUtils() {
        Area area;
        long l = System.currentTimeMillis();
        areas = new HashMap<Integer, Area>();
        areas.put(Area.ID_GLOBAL, new Area(Area.ID_GLOBAL, "\u5168\u7403", 0, null, new ArrayList<Area>()));
        List list = CsvUtil.getReader().read((Reader)ResourceUtil.getUtf8Reader((String)"area.csv")).getRows();
        list.remove(0);
        for (CsvRow csvRow : list) {
            area = new Area(Integer.valueOf(csvRow.get(0)), csvRow.get(1), Integer.valueOf(csvRow.get(2)), null, new ArrayList<Area>());
            areas.put(area.getId(), area);
        }
        for (CsvRow csvRow : list) {
            Area area2;
            area = areas.get(Integer.valueOf(csvRow.get(0)));
            Assert.isTrue((area != (area2 = areas.get(Integer.valueOf(csvRow.get(3)))) ? 1 : 0) != 0, (String)"{}:\u7236\u5b50\u8282\u70b9\u76f8\u540c", (Object[])new Object[]{area.getName()});
            area.setParent(area2);
            area2.getChildren().add(area);
        }
        log.info("\u542f\u52a8\u52a0\u8f7d AreaUtils \u6210\u529f\uff0c\u8017\u65f6 ({}) \u6beb\u79d2", (Object)(System.currentTimeMillis() - l));
    }

    public static Area getArea(Integer n) {
        return areas.get(n);
    }

    public static Area parseArea(String string) {
        String[] stringArray = string.split("/");
        Area area2 = null;
        for (String string2 : stringArray) {
            area2 = area2 == null ? (Area)CollectionUtils.findFirst(areas.values(), area -> area.getName().equals(string2)) : (Area)CollectionUtils.findFirst(area2.getChildren(), area -> area.getName().equals(string2));
        }
        return area2;
    }

    public static List<String> getAreaNodePathList(List<Area> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        list.forEach(area -> AreaUtils.getAreaNodePathList(area, "", arrayList));
        return arrayList;
    }

    private static void getAreaNodePathList(Area area, String string, List<String> list) {
        if (area == null) {
            return;
        }
        String string2 = string.isEmpty() ? area.getName() : string + "/" + area.getName();
        list.add(string2);
        for (Area area2 : area.getChildren()) {
            AreaUtils.getAreaNodePathList(area2, string2, list);
        }
    }

    public static String format(Integer n) {
        return AreaUtils.format(n, " ");
    }

    public static String format(Integer n, String string) {
        Area area = areas.get(n);
        if (area == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < AreaTypeEnum.values().length; ++i) {
            stringBuilder.insert(0, area.getName());
            area = area.getParent();
            if (area == null || ObjectUtils.equalsAny((Object)area.getId(), (Object[])new Integer[]{Area.ID_GLOBAL, Area.ID_CHINA})) break;
            stringBuilder.insert(0, string);
        }
        return stringBuilder.toString();
    }

    public static <T> List<T> getByType(AreaTypeEnum areaTypeEnum, Function<Area, T> function) {
        return CollectionUtils.convertList(areas.values(), function, area -> areaTypeEnum.getType().equals(area.getType()));
    }

    public static Integer getParentIdByType(Integer n, @NonNull AreaTypeEnum areaTypeEnum) {
        if (areaTypeEnum == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        for (int i = 0; i < 127; ++i) {
            Area area = AreaUtils.getArea(n);
            if (area == null) {
                return null;
            }
            if (areaTypeEnum.getType().equals(area.getType())) {
                return area.getId();
            }
            if (area.getParent() == null || area.getParent().getId() == null) {
                return null;
            }
            n = area.getParent().getId();
        }
        return null;
    }
}

