/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.tenant.config;

import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.lenovo.cloud.framework.mybatis.core.util.MyBatisUtils;
import com.lenovo.cloud.framework.redis.config.LenovoCacheProperties;
import com.lenovo.cloud.framework.tenant.config.TenantProperties;
import com.lenovo.cloud.framework.tenant.core.aop.TenantIgnoreAspect;
import com.lenovo.cloud.framework.tenant.core.db.TenantDatabaseInterceptor;
import com.lenovo.cloud.framework.tenant.core.job.TenantJobAspect;
import com.lenovo.cloud.framework.tenant.core.mq.rabbitmq.TenantRabbitMQInitializer;
import com.lenovo.cloud.framework.tenant.core.mq.redis.TenantRedisMessageInterceptor;
import com.lenovo.cloud.framework.tenant.core.mq.rocketmq.TenantRocketMQInitializer;
import com.lenovo.cloud.framework.tenant.core.redis.TenantRedisCacheManager;
import com.lenovo.cloud.framework.tenant.core.security.TenantSecurityWebFilter;
import com.lenovo.cloud.framework.tenant.core.service.TenantFrameworkService;
import com.lenovo.cloud.framework.tenant.core.service.TenantFrameworkServiceImpl;
import com.lenovo.cloud.framework.tenant.core.web.TenantContextWebFilter;
import com.lenovo.cloud.framework.web.config.WebProperties;
import com.lenovo.cloud.framework.web.core.handler.GlobalExceptionHandler;
import com.lenovo.cloud.module.system.api.tenant.TenantApi;
import jakarta.servlet.Filter;
import java.util.Objects;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.BatchStrategies;
import org.springframework.data.redis.cache.BatchStrategy;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

@AutoConfiguration
@ConditionalOnProperty(prefix="lenovo.tenant", value={"enable"}, matchIfMissing=true)
@EnableConfigurationProperties(value={TenantProperties.class})
public class TenantAutoConfiguration {
    @Bean
    public TenantFrameworkService tenantFrameworkService(TenantApi tenantApi) {
        return new TenantFrameworkServiceImpl(tenantApi);
    }

    @Bean
    public TenantIgnoreAspect tenantIgnoreAspect() {
        return new TenantIgnoreAspect();
    }

    @Bean
    public TenantLineInnerInterceptor tenantLineInnerInterceptor(TenantProperties tenantProperties, MybatisPlusInterceptor mybatisPlusInterceptor) {
        TenantLineInnerInterceptor tenantLineInnerInterceptor = new TenantLineInnerInterceptor((TenantLineHandler)new TenantDatabaseInterceptor(tenantProperties));
        MyBatisUtils.addInterceptor((MybatisPlusInterceptor)mybatisPlusInterceptor, (InnerInterceptor)tenantLineInnerInterceptor, (int)0);
        return tenantLineInnerInterceptor;
    }

    @Bean
    public FilterRegistrationBean<TenantContextWebFilter> tenantContextWebFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new TenantContextWebFilter());
        filterRegistrationBean.setOrder(-104);
        return filterRegistrationBean;
    }

    @Bean
    public FilterRegistrationBean<TenantSecurityWebFilter> tenantSecurityWebFilter(TenantProperties tenantProperties, WebProperties webProperties, GlobalExceptionHandler globalExceptionHandler, TenantFrameworkService tenantFrameworkService) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new TenantSecurityWebFilter(tenantProperties, webProperties, globalExceptionHandler, tenantFrameworkService));
        filterRegistrationBean.setOrder(-99);
        return filterRegistrationBean;
    }

    @Bean
    @ConditionalOnClass(name={"com.xxl.job.core.handler.annotation.XxlJob"})
    public TenantJobAspect tenantJobAspect(TenantFrameworkService tenantFrameworkService) {
        return new TenantJobAspect(tenantFrameworkService);
    }

    @Bean
    @ConditionalOnClass(name={"org.springframework.amqp.rabbit.core.RabbitTemplate"})
    public TenantRabbitMQInitializer tenantRabbitMQInitializer() {
        return new TenantRabbitMQInitializer();
    }

    @Bean
    @ConditionalOnClass(name={"org.apache.rocketmq.spring.core.RocketMQTemplate"})
    public TenantRocketMQInitializer tenantRocketMQInitializer() {
        return new TenantRocketMQInitializer();
    }

    @Bean
    @Primary
    public RedisCacheManager tenantRedisCacheManager(RedisTemplate<String, Object> redisTemplate, RedisCacheConfiguration redisCacheConfiguration, LenovoCacheProperties lenovoCacheProperties, TenantProperties tenantProperties) {
        RedisConnectionFactory redisConnectionFactory = Objects.requireNonNull(redisTemplate.getConnectionFactory());
        RedisCacheWriter redisCacheWriter = RedisCacheWriter.nonLockingRedisCacheWriter((RedisConnectionFactory)redisConnectionFactory, (BatchStrategy)BatchStrategies.scan((int)lenovoCacheProperties.getRedisScanBatchSize()));
        return new TenantRedisCacheManager(redisCacheWriter, redisCacheConfiguration, tenantProperties.getIgnoreCaches());
    }

    @Configuration
    @ConditionalOnClass(name={"com.lenovo.cloud.framework.mq.redis.core.RedisMQTemplate"})
    public static class TenantRedisMQAutoConfiguration {
        @Bean
        public TenantRedisMessageInterceptor tenantRedisMessageInterceptor() {
            return new TenantRedisMessageInterceptor();
        }
    }
}

