/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.tenant.core.job;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.util.StrUtil;
import com.lenovo.cloud.framework.common.util.json.JsonUtils;
import com.lenovo.cloud.framework.tenant.core.job.TenantJob;
import com.lenovo.cloud.framework.tenant.core.service.TenantFrameworkService;
import com.lenovo.cloud.framework.tenant.core.util.TenantUtils;
import com.xxl.job.core.context.XxlJobContext;
import com.xxl.job.core.context.XxlJobHelper;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class TenantJobAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantJobAspect.class);
    private final TenantFrameworkService tenantFrameworkService;

    @Around(value="@annotation(tenantJob)")
    public void around(ProceedingJoinPoint proceedingJoinPoint, TenantJob tenantJob) {
        List<Long> list = this.tenantFrameworkService.getTenantIds();
        if (CollUtil.isEmpty(list)) {
            return;
        }
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        XxlJobContext xxlJobContext = XxlJobContext.getXxlJobContext();
        list.parallelStream().forEach(l -> TenantUtils.execute(l, () -> {
            try {
                XxlJobContext.setXxlJobContext((XxlJobContext)xxlJobContext);
                Object object = proceedingJoinPoint.proceed();
                concurrentHashMap.put(l, StrUtil.toStringOrEmpty((Object)object));
            }
            catch (Throwable throwable) {
                concurrentHashMap.put(l, ExceptionUtil.getRootCauseMessage((Throwable)throwable));
                atomicBoolean.set(false);
                XxlJobHelper.log((String)StrUtil.format((CharSequence)"[\u591a\u79df\u6237({}) \u6267\u884c\u4efb\u52a1({})\uff0c\u53d1\u751f\u5f02\u5e38\uff1a{}]", (Object[])new Object[]{l, proceedingJoinPoint.getSignature(), ExceptionUtils.getStackTrace((Throwable)throwable)}), (Object[])new Object[0]);
            }
        }));
        if (atomicBoolean.get()) {
            XxlJobHelper.handleSuccess((String)JsonUtils.toJsonString(concurrentHashMap));
        } else {
            XxlJobHelper.handleFail((String)JsonUtils.toJsonString(concurrentHashMap));
        }
    }

    @Generated
    public TenantJobAspect(TenantFrameworkService tenantFrameworkService) {
        this.tenantFrameworkService = tenantFrameworkService;
    }
}

