/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.tenant.core.mq.rocketmq;

import com.lenovo.cloud.framework.tenant.core.mq.rocketmq.TenantRocketMQConsumeMessageHook;
import com.lenovo.cloud.framework.tenant.core.mq.rocketmq.TenantRocketMQSendMessageHook;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.hook.ConsumeMessageHook;
import org.apache.rocketmq.client.hook.SendMessageHook;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import org.apache.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.apache.rocketmq.spring.support.DefaultRocketMQListenerContainer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class TenantRocketMQInitializer
implements BeanPostProcessor {
    public Object postProcessAfterInitialization(Object object, String string) throws BeansException {
        if (object instanceof DefaultRocketMQListenerContainer) {
            DefaultRocketMQListenerContainer defaultRocketMQListenerContainer = (DefaultRocketMQListenerContainer)object;
            this.initTenantConsumer(defaultRocketMQListenerContainer.getConsumer());
        } else if (object instanceof RocketMQTemplate) {
            RocketMQTemplate rocketMQTemplate = (RocketMQTemplate)object;
            this.initTenantProducer(rocketMQTemplate.getProducer());
        }
        return object;
    }

    private void initTenantProducer(DefaultMQProducer defaultMQProducer) {
        if (defaultMQProducer == null) {
            return;
        }
        DefaultMQProducerImpl defaultMQProducerImpl = defaultMQProducer.getDefaultMQProducerImpl();
        if (defaultMQProducerImpl == null) {
            return;
        }
        defaultMQProducerImpl.registerSendMessageHook((SendMessageHook)new TenantRocketMQSendMessageHook());
    }

    private void initTenantConsumer(DefaultMQPushConsumer defaultMQPushConsumer) {
        if (defaultMQPushConsumer == null) {
            return;
        }
        DefaultMQPushConsumerImpl defaultMQPushConsumerImpl = defaultMQPushConsumer.getDefaultMQPushConsumerImpl();
        if (defaultMQPushConsumerImpl == null) {
            return;
        }
        defaultMQPushConsumerImpl.registerConsumeMessageHook((ConsumeMessageHook)new TenantRocketMQConsumeMessageHook());
    }
}

