/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.tenant.core.security;

import cn.hutool.core.collection.CollUtil;
import com.lenovo.cloud.framework.common.exception.enums.GlobalErrorCodeConstants;
import com.lenovo.cloud.framework.common.pojo.CommonResult;
import com.lenovo.cloud.framework.common.util.servlet.ServletUtils;
import com.lenovo.cloud.framework.security.core.LoginUser;
import com.lenovo.cloud.framework.security.core.util.SecurityFrameworkUtils;
import com.lenovo.cloud.framework.tenant.config.TenantProperties;
import com.lenovo.cloud.framework.tenant.core.context.TenantContextHolder;
import com.lenovo.cloud.framework.tenant.core.service.TenantFrameworkService;
import com.lenovo.cloud.framework.web.config.WebProperties;
import com.lenovo.cloud.framework.web.core.filter.ApiRequestFilter;
import com.lenovo.cloud.framework.web.core.handler.GlobalExceptionHandler;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public class TenantSecurityWebFilter
extends ApiRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantSecurityWebFilter.class);
    private final TenantProperties tenantProperties;
    private final AntPathMatcher pathMatcher;
    private final GlobalExceptionHandler globalExceptionHandler;
    private final TenantFrameworkService tenantFrameworkService;

    public TenantSecurityWebFilter(TenantProperties tenantProperties, WebProperties webProperties, GlobalExceptionHandler globalExceptionHandler, TenantFrameworkService tenantFrameworkService) {
        super(webProperties);
        this.tenantProperties = tenantProperties;
        this.pathMatcher = new AntPathMatcher();
        this.globalExceptionHandler = globalExceptionHandler;
        this.tenantFrameworkService = tenantFrameworkService;
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        Long l = TenantContextHolder.getTenantId();
        LoginUser loginUser = SecurityFrameworkUtils.getLoginUser();
        if (loginUser != null) {
            if (l == null) {
                l = loginUser.getTenantId();
                TenantContextHolder.setTenantId(l);
            } else if (!Objects.equals(loginUser.getTenantId(), TenantContextHolder.getTenantId())) {
                log.error("[doFilterInternal][\u79df\u6237({}) User({}/{}) \u8d8a\u6743\u8bbf\u95ee\u79df\u6237({}) URL({}/{})]", new Object[]{loginUser.getTenantId(), loginUser.getId(), loginUser.getUserType(), TenantContextHolder.getTenantId(), httpServletRequest.getRequestURI(), httpServletRequest.getMethod()});
                ServletUtils.writeJSON((HttpServletResponse)httpServletResponse, (Object)CommonResult.error((Integer)GlobalErrorCodeConstants.FORBIDDEN.getCode(), (String)"\u60a8\u65e0\u6743\u8bbf\u95ee\u8be5\u79df\u6237\u7684\u6570\u636e"));
                return;
            }
        }
        if (!this.isIgnoreUrl(httpServletRequest)) {
            if (l == null) {
                log.error("[doFilterInternal][URL({}/{}) \u672a\u4f20\u9012\u79df\u6237\u7f16\u53f7]", (Object)httpServletRequest.getRequestURI(), (Object)httpServletRequest.getMethod());
                ServletUtils.writeJSON((HttpServletResponse)httpServletResponse, (Object)CommonResult.error((Integer)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (String)"\u8bf7\u6c42\u7684\u79df\u6237\u6807\u8bc6\u672a\u4f20\u9012\uff0c\u8bf7\u8fdb\u884c\u6392\u67e5"));
                return;
            }
            try {
                this.tenantFrameworkService.validTenant(l);
            }
            catch (Throwable throwable) {
                CommonResult commonResult = this.globalExceptionHandler.allExceptionHandler(httpServletRequest, throwable);
                ServletUtils.writeJSON((HttpServletResponse)httpServletResponse, (Object)commonResult);
                return;
            }
        } else if (l == null) {
            TenantContextHolder.setIgnore(true);
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private boolean isIgnoreUrl(HttpServletRequest httpServletRequest) {
        if (CollUtil.contains(this.tenantProperties.getIgnoreUrls(), (Object)httpServletRequest.getRequestURI())) {
            return true;
        }
        for (String string : this.tenantProperties.getIgnoreUrls()) {
            if (!this.pathMatcher.match(string, httpServletRequest.getRequestURI())) continue;
            return true;
        }
        return false;
    }
}

