/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.custom.security.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lenovo.cloud.framework.custom.security.config.properties.ActuatorProperties;
import com.lenovo.cloud.framework.custom.security.config.properties.CustomSecurityProperties;
import com.lenovo.cloud.framework.custom.security.config.properties.FileUploadProperties;
import com.lenovo.cloud.framework.custom.security.config.properties.IpBlacklistProperties;
import com.lenovo.cloud.framework.custom.security.config.properties.RateLimitProperties;
import com.lenovo.cloud.framework.custom.security.config.properties.SecurityHeadersProperties;
import com.lenovo.cloud.framework.custom.security.config.properties.SensitiveDataProperties;
import com.lenovo.cloud.framework.custom.security.config.properties.SqlInjectionProperties;
import com.lenovo.cloud.framework.custom.security.config.properties.SsrfProperties;
import com.lenovo.cloud.framework.custom.security.config.properties.XssProperties;
import com.lenovo.cloud.framework.custom.security.filter.ActuatorSecurityFilter;
import com.lenovo.cloud.framework.custom.security.filter.FileUploadSecurityFilter;
import com.lenovo.cloud.framework.custom.security.filter.IpBlacklistFilter;
import com.lenovo.cloud.framework.custom.security.filter.RateLimitFilter;
import com.lenovo.cloud.framework.custom.security.filter.SensitiveDataFilter;
import com.lenovo.cloud.framework.custom.security.filter.SqlInjectionFilter;
import com.lenovo.cloud.framework.custom.security.filter.SsrfFilter;
import com.lenovo.cloud.framework.custom.security.filter.XssFilter;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

@Configuration
@EnableConfigurationProperties(value={CustomSecurityProperties.class, RateLimitProperties.class, IpBlacklistProperties.class, SensitiveDataProperties.class, XssProperties.class, SsrfProperties.class, FileUploadProperties.class, ActuatorProperties.class, SqlInjectionProperties.class, SecurityHeadersProperties.class})
@ConditionalOnProperty(prefix="lenovo.security", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class CustomSecurityConfiguration {
    private final CustomSecurityProperties securityProperties;
    private final RateLimitProperties rateLimitProperties;
    private final IpBlacklistProperties ipBlacklistProperties;
    private final SensitiveDataProperties sensitiveDataProperties;
    private final XssProperties xssProperties;
    private final SsrfProperties ssrfProperties;
    private final FileUploadProperties fileUploadProperties;
    private final ActuatorProperties actuatorProperties;
    private final SqlInjectionProperties sqlInjectionProperties;
    private final RedisTemplate<String, Object> redisTemplate;
    private final ObjectMapper objectMapper;
    private final SecurityHeadersProperties securityHeadersProperties;
    private final AntPathMatcher pathMatcher;

    public CustomSecurityConfiguration(CustomSecurityProperties customSecurityProperties, RateLimitProperties rateLimitProperties, IpBlacklistProperties ipBlacklistProperties, SensitiveDataProperties sensitiveDataProperties, XssProperties xssProperties, SsrfProperties ssrfProperties, FileUploadProperties fileUploadProperties, ActuatorProperties actuatorProperties, SqlInjectionProperties sqlInjectionProperties, RedisTemplate<String, Object> redisTemplate, ObjectMapper objectMapper, SecurityHeadersProperties securityHeadersProperties) {
        this.securityProperties = customSecurityProperties;
        this.rateLimitProperties = rateLimitProperties;
        this.ipBlacklistProperties = ipBlacklistProperties;
        this.sensitiveDataProperties = sensitiveDataProperties;
        this.xssProperties = xssProperties;
        this.ssrfProperties = ssrfProperties;
        this.fileUploadProperties = fileUploadProperties;
        this.actuatorProperties = actuatorProperties;
        this.sqlInjectionProperties = sqlInjectionProperties;
        this.redisTemplate = redisTemplate;
        this.objectMapper = objectMapper;
        this.securityHeadersProperties = securityHeadersProperties;
        this.pathMatcher = new AntPathMatcher();
    }

    @Bean
    public FilterRegistrationBean<OncePerRequestFilter> securityFilterRegistration() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)this.securityFilter());
        filterRegistrationBean.setOrder(Integer.MIN_VALUE);
        filterRegistrationBean.addUrlPatterns(new String[]{"/*"});
        return filterRegistrationBean;
    }

    @Bean
    public OncePerRequestFilter securityFilter() {
        return new OncePerRequestFilter(){
            private final List<OncePerRequestFilter> filters = new ArrayList<OncePerRequestFilter>();

            protected void initFilterBean() {
                if (!CustomSecurityConfiguration.this.securityProperties.isEnabled()) {
                    return;
                }
                if (CustomSecurityConfiguration.this.rateLimitProperties.isEnabled()) {
                    this.filters.add(new RateLimitFilter(CustomSecurityConfiguration.this.redisTemplate, CustomSecurityConfiguration.this.rateLimitProperties));
                }
                if (CustomSecurityConfiguration.this.ipBlacklistProperties.isEnabled()) {
                    this.filters.add(new IpBlacklistFilter(CustomSecurityConfiguration.this.redisTemplate, CustomSecurityConfiguration.this.ipBlacklistProperties));
                }
                if (CustomSecurityConfiguration.this.sensitiveDataProperties.isEnabled()) {
                    this.filters.add(new SensitiveDataFilter(CustomSecurityConfiguration.this.objectMapper, CustomSecurityConfiguration.this.sensitiveDataProperties));
                }
                if (CustomSecurityConfiguration.this.xssProperties.isEnabled()) {
                    this.filters.add(new XssFilter(CustomSecurityConfiguration.this.pathMatcher, CustomSecurityConfiguration.this.xssProperties));
                }
                if (CustomSecurityConfiguration.this.ssrfProperties.isEnabled()) {
                    this.filters.add(new SsrfFilter(CustomSecurityConfiguration.this.pathMatcher, CustomSecurityConfiguration.this.ssrfProperties));
                }
                if (CustomSecurityConfiguration.this.fileUploadProperties.isEnabled()) {
                    this.filters.add(new FileUploadSecurityFilter(CustomSecurityConfiguration.this.pathMatcher, CustomSecurityConfiguration.this.fileUploadProperties));
                }
                if (CustomSecurityConfiguration.this.actuatorProperties.isEnabled()) {
                    this.filters.add(new ActuatorSecurityFilter(CustomSecurityConfiguration.this.pathMatcher, CustomSecurityConfiguration.this.actuatorProperties));
                }
                if (CustomSecurityConfiguration.this.sqlInjectionProperties.isEnabled()) {
                    this.filters.add(new SqlInjectionFilter(CustomSecurityConfiguration.this.pathMatcher, CustomSecurityConfiguration.this.sqlInjectionProperties));
                }
            }

            protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
                if (this.isExcludedUrl(httpServletRequest.getRequestURI())) {
                    filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                    return;
                }
                for (OncePerRequestFilter oncePerRequestFilter : this.filters) {
                    oncePerRequestFilter.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse, (servletRequest, servletResponse) -> {});
                }
                filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }

            private boolean isExcludedUrl(String string) {
                return CustomSecurityConfiguration.this.securityProperties.getExcludeUrls().stream().anyMatch(string2 -> CustomSecurityConfiguration.this.pathMatcher.match(string2, string));
            }
        };
    }
}

