/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.custom.security.filter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.lenovo.cloud.framework.custom.security.config.properties.SensitiveDataProperties;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.ContentCachingRequestWrapper;
import org.springframework.web.util.ContentCachingResponseWrapper;

@Component
public class SensitiveDataFilter
extends OncePerRequestFilter {
    private final ObjectMapper objectMapper;
    private final SensitiveDataProperties sensitiveDataProperties;
    private final List<Pattern> sensitivePatterns;

    public SensitiveDataFilter(ObjectMapper objectMapper, SensitiveDataProperties sensitiveDataProperties) {
        this.objectMapper = objectMapper;
        this.sensitiveDataProperties = sensitiveDataProperties;
        this.sensitivePatterns = sensitiveDataProperties.getSensitivePatterns().stream().map(Pattern::compile).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (!this.sensitiveDataProperties.isEnabled()) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        ContentCachingRequestWrapper contentCachingRequestWrapper = new ContentCachingRequestWrapper(httpServletRequest);
        ContentCachingResponseWrapper contentCachingResponseWrapper = new ContentCachingResponseWrapper(httpServletResponse);
        try {
            filterChain.doFilter((ServletRequest)contentCachingRequestWrapper, (ServletResponse)contentCachingResponseWrapper);
        }
        finally {
            String string = new String(contentCachingResponseWrapper.getContentAsByteArray());
            if (!string.isEmpty()) {
                try {
                    Object object = this.objectMapper.readValue(string, Object.class);
                    if (object instanceof Map) {
                        this.maskSensitiveData((Map)object);
                        string = this.objectMapper.writeValueAsString(object);
                    } else {
                        string = this.maskSensitiveText(string);
                    }
                }
                catch (Exception exception) {
                    string = this.maskSensitiveText(string);
                }
            }
            contentCachingResponseWrapper.resetBuffer();
            contentCachingResponseWrapper.getWriter().write(string);
            contentCachingResponseWrapper.copyBodyToResponse();
        }
    }

    private void maskSensitiveData(Map<String, Object> map) {
        map.forEach((string, object) -> {
            String string2;
            if (object instanceof Map) {
                this.maskSensitiveData((Map)object);
            } else if (object instanceof String && this.isSensitiveData(string2 = (String)object)) {
                map.put((String)string, this.maskValue(string2));
            }
        });
    }

    private String maskSensitiveText(String string) {
        String string2 = string;
        for (Pattern pattern : this.sensitivePatterns) {
            string2 = pattern.matcher(string2).replaceAll(matchResult -> this.maskValue(matchResult.group()));
        }
        return string2;
    }

    private boolean isSensitiveData(String string) {
        return this.sensitivePatterns.stream().anyMatch(pattern -> pattern.matcher(string).matches());
    }

    private String maskValue(String string) {
        if (string.length() <= 4) {
            return "*".repeat(string.length());
        }
        return string.substring(0, 2) + "*".repeat(string.length() - 4) + string.substring(string.length() - 2);
    }
}

