/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.custom.security.filter;

import com.lenovo.cloud.framework.custom.security.config.properties.SsrfProperties;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class SsrfFilter
extends OncePerRequestFilter {
    private final AntPathMatcher pathMatcher;
    private final SsrfProperties properties;

    public SsrfFilter(AntPathMatcher antPathMatcher, SsrfProperties ssrfProperties) {
        this.pathMatcher = antPathMatcher;
        this.properties = ssrfProperties;
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (this.isExcludedUrl(httpServletRequest.getRequestURI())) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        String string = httpServletRequest.getParameter("url");
        if (string != null && !string.isEmpty()) {
            try {
                URL uRL = new URL(string);
                String string2 = uRL.getHost().toLowerCase();
                if (!this.isWhitelistedDomain(string2)) {
                    httpServletResponse.sendError(403, "SSRF attack detected");
                    return;
                }
            }
            catch (Exception exception) {
                httpServletResponse.sendError(400, "Invalid URL");
                return;
            }
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private boolean isExcludedUrl(String string) {
        List<String> list = this.properties.getExcludeUrls();
        return list.stream().anyMatch(string2 -> this.pathMatcher.match(string2, string));
    }

    private boolean isWhitelistedDomain(String string) {
        List<String> list = this.properties.getWhitelistDomains();
        return list.stream().anyMatch(string2 -> string.endsWith(string2.toLowerCase()));
    }
}

