/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.env.config;

import com.lenovo.cloud.framework.env.config.EnvProperties;
import com.lenovo.cloud.framework.env.core.fegin.EnvLoadBalancerClientFactory;
import com.lenovo.cloud.framework.env.core.fegin.EnvRequestInterceptor;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClientsProperties;
import org.springframework.cloud.loadbalancer.annotation.LoadBalancerClientSpecification;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={EnvProperties.class})
public class EnvRpcAutoConfiguration {
    private final EnvProperties envProperties;

    public EnvRpcAutoConfiguration(EnvProperties envProperties) {
        this.envProperties = envProperties;
    }

    @Bean
    public LoadBalancerClientFactory loadBalancerClientFactory(LoadBalancerClientsProperties loadBalancerClientsProperties, ObjectProvider<List<LoadBalancerClientSpecification>> objectProvider) {
        EnvLoadBalancerClientFactory envLoadBalancerClientFactory = new EnvLoadBalancerClientFactory(loadBalancerClientsProperties, this.envProperties);
        envLoadBalancerClientFactory.setConfigurations((List)objectProvider.getIfAvailable(Collections::emptyList));
        return envLoadBalancerClientFactory;
    }

    @Bean
    public EnvRequestInterceptor envRequestInterceptor() {
        return new EnvRequestInterceptor();
    }
}

