/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.env.core.fegin;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.cloud.nacos.balancer.NacosBalancer;
import com.lenovo.cloud.framework.env.config.EnvProperties;
import com.lenovo.cloud.framework.env.core.context.EnvContextHolder;
import com.lenovo.cloud.framework.env.core.util.EnvUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.loadbalancer.core.NoopServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ReactorServiceInstanceLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class EnvLoadBalancerClient
implements ReactorServiceInstanceLoadBalancer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnvLoadBalancerClient.class);
    private final ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider;
    private final String serviceId;
    private final ReactiveLoadBalancer<ServiceInstance> reactiveLoadBalancer;
    private final AtomicInteger position;
    private final EnvProperties envProperties;

    public Mono<Response<ServiceInstance>> choose(Request request) {
        String string = EnvContextHolder.getTag();
        if (StrUtil.isEmpty((CharSequence)string)) {
            if (this.envProperties.getDevEnabled().booleanValue()) {
                ServiceInstanceListSupplier serviceInstanceListSupplier = (ServiceInstanceListSupplier)this.serviceInstanceListSupplierProvider.getIfAvailable(NoopServiceInstanceListSupplier::new);
                Mono mono = serviceInstanceListSupplier.get(request).next().map(list -> this.getInstanceResponse((List<ServiceInstance>)list, request));
                return mono;
            }
            return Mono.from((Publisher)this.reactiveLoadBalancer.choose(request));
        }
        ServiceInstanceListSupplier serviceInstanceListSupplier = (ServiceInstanceListSupplier)this.serviceInstanceListSupplierProvider.getIfAvailable(NoopServiceInstanceListSupplier::new);
        return serviceInstanceListSupplier.get(request).next().map(list -> this.getInstanceResponse((List<ServiceInstance>)list, string));
    }

    Response<ServiceInstance> getInstanceResponse(List<ServiceInstance> list, Request request) {
        if (CollectionUtils.isEmpty(list)) {
            log.warn("No instance available {}", (Object)this.serviceId);
            return new EmptyResponse();
        }
        String string = this.envProperties.getDevIpPrefix();
        String[] stringArray = string.split(",");
        ConcurrentHashMap<String, ServiceInstance> concurrentHashMap = new ConcurrentHashMap<String, ServiceInstance>();
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            log.error("\u83b7\u53d6\u672c\u5730Ip\u53d1\u751f\u5f02\u5e38\u8c03\u7528\u7236\u7c7b\u65b9\u6cd5:", (Throwable)unknownHostException);
            return this.roundRobinLoadBalancer(list, request);
        }
        log.debug("loadBalance select ip is:{}", (Object)string2);
        if (StringUtils.hasLength((String)string2)) {
            ArrayList<ServiceInstance> arrayList = new ArrayList<ServiceInstance>();
            String string3 = null;
            for (ServiceInstance serviceInstance2 : list) {
                if (string2.equals(serviceInstance2.getHost())) {
                    string3 = serviceInstance2.getHost();
                    concurrentHashMap.put(serviceInstance2.getHost(), serviceInstance2);
                }
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!serviceInstance2.getHost().contains(stringArray[i])) continue;
                    arrayList.add(serviceInstance2);
                }
            }
            if (!CollectionUtils.isEmpty(concurrentHashMap) && string3 != null) {
                log.debug("\u8bf7\u6c42\u672c\u5730IP\uff1a{}", string3);
                return new DefaultResponse((ServiceInstance)concurrentHashMap.get(string3));
            }
            if (!CollectionUtils.isEmpty(arrayList)) {
                ServiceInstance serviceInstance2;
                arrayList.parallelStream().forEach(serviceInstance -> log.debug("\u83b7\u53d6\u5230\u6d4b\u8bd5\u73af\u5883\u76f8\u5173\u7684\u670d\u52a1\u5217\u8868\uff1a{},ip\uff1a{}", (Object)serviceInstance.getInstanceId(), (Object)serviceInstance.getHost()));
                int n = Math.abs(this.position.incrementAndGet());
                serviceInstance2 = (ServiceInstance)arrayList.get(n % arrayList.size());
                log.debug("\u8bf7\u6c42\u670d\u52a1\u5668IP\uff1a{}", (Object)serviceInstance2.getHost());
                return new DefaultResponse(serviceInstance2);
            }
        }
        return this.roundRobinLoadBalancer(list, request);
    }

    private Response<ServiceInstance> roundRobinLoadBalancer(List<ServiceInstance> list, Request request) {
        log.debug("select roundRobin loadBalance");
        int n = Math.abs(this.position.incrementAndGet());
        ServiceInstance serviceInstance = list.get(n % list.size());
        log.debug("\u4f7f\u7528\u8f6e\u8be2\u7b56\u7565\uff0c\u8bf7\u6c42\u670d\u52a1\u5668IP\uff1a{}", (Object)serviceInstance.getHost());
        return new DefaultResponse(serviceInstance);
    }

    private Response<ServiceInstance> getInstanceResponse(List<ServiceInstance> list, String string) {
        if (CollUtil.isEmpty(list)) {
            log.warn("[getInstanceResponse][serviceId({}) \u670d\u52a1\u5b9e\u4f8b\u5217\u8868\u4e3a\u7a7a]", (Object)this.serviceId);
            return new EmptyResponse();
        }
        List<ServiceInstance> list2 = com.lenovo.cloud.framework.common.util.collection.CollectionUtils.filterList(list, serviceInstance -> string.equals(EnvUtils.getTag(serviceInstance)));
        if (CollUtil.isEmpty((Collection)list2)) {
            log.warn("[getInstanceResponse][serviceId({}) \u6ca1\u6709\u6ee1\u8db3 tag({}) \u7684\u670d\u52a1\u5b9e\u4f8b\u5217\u8868\uff0c\u76f4\u63a5\u4f7f\u7528\u6240\u6709\u670d\u52a1\u5b9e\u4f8b\u5217\u8868]", (Object)this.serviceId, (Object)string);
            list2 = list;
        }
        return new DefaultResponse(NacosBalancer.getHostByRandomWeight3((List)list2));
    }

    @Generated
    public EnvLoadBalancerClient(ObjectProvider<ServiceInstanceListSupplier> objectProvider, String string, ReactiveLoadBalancer<ServiceInstance> reactiveLoadBalancer, AtomicInteger atomicInteger, EnvProperties envProperties) {
        this.serviceInstanceListSupplierProvider = objectProvider;
        this.serviceId = string;
        this.reactiveLoadBalancer = reactiveLoadBalancer;
        this.position = atomicInteger;
        this.envProperties = envProperties;
    }
}

