/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.env.core.util;

import feign.RequestTemplate;
import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.util.List;
import java.util.Objects;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.core.env.Environment;
import org.springframework.web.server.ServerWebExchange;

public class EnvUtils {
    private static final String HEADER_TAG = "tag";
    public static final String HOST_NAME_VALUE = "${HOSTNAME}";

    public static String getTag(ServerWebExchange serverWebExchange) {
        List list = serverWebExchange.getRequest().getHeaders().get((Object)HEADER_TAG);
        if (Objects.nonNull(list)) {
            return (String)list.get(0);
        }
        return null;
    }

    public static String getTag(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader(HEADER_TAG);
        return Objects.equals(string, HOST_NAME_VALUE) ? EnvUtils.getHostName() : string;
    }

    public static String getTag(ServiceInstance serviceInstance) {
        return (String)serviceInstance.getMetadata().get(HEADER_TAG);
    }

    public static String getTag(Environment environment) {
        String string = environment.getProperty("lenovo.env.tag");
        return Objects.equals(string, HOST_NAME_VALUE) ? EnvUtils.getHostName() : string;
    }

    public static void setTag(RequestTemplate requestTemplate, String string) {
        requestTemplate.header(HEADER_TAG, new String[]{string});
    }

    public static String getHostName() {
        return InetAddress.getLocalHost().getHostName();
    }
}

