/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.excel.core.handler;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.poi.excel.ExcelUtil;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import com.lenovo.cloud.framework.common.core.KeyValue;
import com.lenovo.cloud.framework.common.util.collection.CollectionUtils;
import com.lenovo.cloud.framework.dict.core.DictFrameworkUtils;
import com.lenovo.cloud.framework.excel.core.annotations.ExcelColumnSelect;
import com.lenovo.cloud.framework.excel.core.function.ExcelColumnSelectFunction;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.poi.hssf.usermodel.HSSFDataValidation;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectSheetWriteHandler
implements SheetWriteHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SelectSheetWriteHandler.class);
    public static final int FIRST_ROW = 1;
    public static final int LAST_ROW = 2000;
    private static final String DICT_SHEET_NAME = "\u5b57\u5178sheet";
    private final Map<Integer, List<String>> selectMap = new HashMap<Integer, List<String>>();

    public SelectSheetWriteHandler(Class<?> clazz) {
        int n = 0;
        for (Field field : clazz.getDeclaredFields()) {
            if (field.isAnnotationPresent(ExcelColumnSelect.class)) {
                ExcelProperty excelProperty = field.getAnnotation(ExcelProperty.class);
                if (excelProperty != null && excelProperty.index() != -1) {
                    n = excelProperty.index();
                }
                this.getSelectDataList(n, field);
            }
            ++n;
        }
    }

    private void getSelectDataList(int n, Field field) {
        ExcelColumnSelect excelColumnSelect = field.getAnnotation(ExcelColumnSelect.class);
        String string = excelColumnSelect.dictType();
        String string2 = excelColumnSelect.functionName();
        Assert.isTrue((ObjectUtil.isNotEmpty((Object)string) || ObjectUtil.isNotEmpty((Object)string2) ? 1 : 0) != 0, (String)"Field({}) \u7684 @ExcelColumnSelect \u6ce8\u89e3\uff0cdictType \u548c functionName \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (Object[])new Object[]{field.getName()});
        if (StrUtil.isNotEmpty((CharSequence)string)) {
            this.selectMap.put(n, DictFrameworkUtils.getDictDataLabelList(string));
            return;
        }
        Map map = SpringUtil.getApplicationContext().getBeansOfType(ExcelColumnSelectFunction.class);
        ExcelColumnSelectFunction excelColumnSelectFunction2 = (ExcelColumnSelectFunction)CollUtil.findOne(map.values(), excelColumnSelectFunction -> excelColumnSelectFunction.getName().equals(string2));
        Assert.notNull((Object)excelColumnSelectFunction2, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684 function({})", (Object[])new Object[]{string2});
        this.selectMap.put(n, excelColumnSelectFunction2.getOptions());
    }

    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        if (CollUtil.isEmpty(this.selectMap)) {
            return;
        }
        DataValidationHelper dataValidationHelper = writeSheetHolder.getSheet().getDataValidationHelper();
        Workbook workbook = writeWorkbookHolder.getWorkbook();
        List list = CollectionUtils.convertList(this.selectMap.entrySet(), entry -> new KeyValue((Object)((Integer)entry.getKey()), (Object)((List)entry.getValue())));
        list.sort(Comparator.comparing(keyValue -> ((List)keyValue.getValue()).size()));
        Sheet sheet = workbook.createSheet(DICT_SHEET_NAME);
        for (KeyValue keyValue2 : list) {
            int n = ((List)keyValue2.getValue()).size();
            for (int i = 0; i < n; ++i) {
                Row row = sheet.getRow(i);
                if (row == null) {
                    row = sheet.createRow(i);
                }
                row.createCell(((Integer)keyValue2.getKey()).intValue()).setCellValue((String)((List)keyValue2.getValue()).get(i));
            }
            SelectSheetWriteHandler.setColumnSelect(writeSheetHolder, workbook, dataValidationHelper, (KeyValue<Integer, List<String>>)keyValue2);
        }
    }

    private static void setColumnSelect(WriteSheetHolder writeSheetHolder, Workbook workbook, DataValidationHelper dataValidationHelper, KeyValue<Integer, List<String>> keyValue) {
        Name name = workbook.createName();
        String string = ExcelUtil.indexToColName((int)((Integer)keyValue.getKey()));
        String string2 = "\u5b57\u5178sheet!$" + string + "$1:$" + string + "$" + ((List)keyValue.getValue()).size();
        name.setNameName("dict" + keyValue.getKey());
        name.setRefersToFormula(string2);
        DataValidationConstraint dataValidationConstraint = dataValidationHelper.createFormulaListConstraint("dict" + keyValue.getKey());
        CellRangeAddressList cellRangeAddressList = new CellRangeAddressList(1, 2000, ((Integer)keyValue.getKey()).intValue(), ((Integer)keyValue.getKey()).intValue());
        DataValidation dataValidation = dataValidationHelper.createValidation(dataValidationConstraint, cellRangeAddressList);
        if (dataValidation instanceof HSSFDataValidation) {
            dataValidation.setSuppressDropDownArrow(false);
        } else {
            dataValidation.setSuppressDropDownArrow(true);
            dataValidation.setShowErrorBox(true);
        }
        dataValidation.setErrorStyle(0);
        dataValidation.createErrorBox("\u63d0\u793a", "\u6b64\u503c\u4e0d\u5b58\u5728\u4e8e\u4e0b\u62c9\u9009\u62e9\u4e2d\uff01");
        writeSheetHolder.getSheet().addValidationData(dataValidation);
    }
}

