/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.jasypt.config;

import com.lenovo.cloud.framework.jasypt.util.JasyptNacosUtils;
import com.lenovo.cloud.framework.jasypt.util.JasyptUtils;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;

public class CustomJasyptEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final int ORDER = -2147473648;

    public void postProcessEnvironment(ConfigurableEnvironment configurableEnvironment, SpringApplication springApplication) {
        StandardPBEStringEncryptor standardPBEStringEncryptor = JasyptUtils.getEncryptorFromEnvironment(configurableEnvironment);
        if (standardPBEStringEncryptor == null) {
            return;
        }
        JasyptNacosUtils.processEnvironment(configurableEnvironment, standardPBEStringEncryptor);
    }

    public int getOrder() {
        return -2147473648;
    }
}

