/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.jasypt.util;

import com.lenovo.cloud.framework.jasypt.constant.JasyptConstants;
import com.lenovo.cloud.framework.jasypt.util.JasyptMapUtils;
import com.lenovo.cloud.framework.jasypt.util.JasyptUtils;
import com.lenovo.cloud.framework.jasypt.util.SystemPropertyUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StreamUtils;
import org.yaml.snakeyaml.Yaml;

public class JasyptNacosUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JasyptNacosUtils.class);
    private static final String[] YAML_EXTENSIONS = new String[]{".yml", ".yaml"};

    public static void processEnvironment(ConfigurableEnvironment configurableEnvironment, StandardPBEStringEncryptor standardPBEStringEncryptor) {
        JasyptNacosUtils.processYamlFiles(configurableEnvironment, JasyptConstants.NACOS_PROPERTY_PREFIXES, standardPBEStringEncryptor);
        MutablePropertySources mutablePropertySources = configurableEnvironment.getPropertySources();
        for (PropertySource propertySource : mutablePropertySources) {
            JasyptNacosUtils.processPropertySource(propertySource, configurableEnvironment, JasyptConstants.NACOS_PROPERTY_PREFIXES, standardPBEStringEncryptor);
        }
        JasyptNacosUtils.processNacosConfigs(configurableEnvironment, standardPBEStringEncryptor);
        JasyptNacosUtils.processOtherConfigs(configurableEnvironment, standardPBEStringEncryptor);
    }

    private static void processNacosConfigs(ConfigurableEnvironment configurableEnvironment, StandardPBEStringEncryptor standardPBEStringEncryptor) {
        MutablePropertySources mutablePropertySources = configurableEnvironment.getPropertySources();
        List<PropertySource<?>> list = JasyptNacosUtils.getPropertySourcesWithPrefixes(mutablePropertySources, JasyptConstants.NACOS_PROPERTY_PREFIXES);
        for (PropertySource<?> propertySource : list) {
            if (!(propertySource instanceof PropertiesPropertySource)) continue;
            PropertiesPropertySource propertiesPropertySource = (PropertiesPropertySource)propertySource;
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)((Map)propertiesPropertySource.getSource()));
            Properties properties2 = JasyptNacosUtils.extractPropertiesWithPrefixes(properties, JasyptConstants.NACOS_PROPERTY_PREFIXES);
            if (properties2.isEmpty()) continue;
            Properties properties3 = JasyptUtils.decryptProperties(properties2, standardPBEStringEncryptor);
            JasyptNacosUtils.setSystemPropertiesWithMapping(properties3, JasyptConstants.NACOS_PROPERTY_PREFIXES, JasyptConstants.NACOS_SYSTEM_PROPERTY_MAPPING);
            PropertySource<?> propertySource2 = JasyptUtils.createDecryptedPropertySource("nacos-" + propertySource.getName(), properties3, standardPBEStringEncryptor);
            mutablePropertySources.replace(propertySource.getName(), propertySource2);
        }
    }

    private static void processOtherConfigs(ConfigurableEnvironment configurableEnvironment, StandardPBEStringEncryptor standardPBEStringEncryptor) {
        MutablePropertySources mutablePropertySources = configurableEnvironment.getPropertySources();
        List<PropertySource<?>> list = JasyptNacosUtils.getPropertySourcesWithoutPrefixes(mutablePropertySources, JasyptConstants.NACOS_PROPERTY_PREFIXES);
        for (PropertySource<?> propertySource : list) {
            if (!(propertySource instanceof PropertiesPropertySource)) continue;
            PropertiesPropertySource propertiesPropertySource = (PropertiesPropertySource)propertySource;
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)((Map)propertiesPropertySource.getSource()));
            PropertySource<?> propertySource2 = JasyptUtils.createDecryptedPropertySource(propertySource.getName(), properties, standardPBEStringEncryptor);
            mutablePropertySources.replace(propertySource.getName(), propertySource2);
        }
    }

    public static List<PropertySource<?>> getPropertySourcesWithPrefixes(MutablePropertySources mutablePropertySources, String[] stringArray) {
        ArrayList arrayList = new ArrayList();
        for (PropertySource propertySource : mutablePropertySources) {
            if (!(propertySource instanceof PropertiesPropertySource)) continue;
            PropertiesPropertySource propertiesPropertySource = (PropertiesPropertySource)propertySource;
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)((Map)propertiesPropertySource.getSource()));
            boolean bl = false;
            for (String string : stringArray) {
                if (!properties.containsKey(string)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            arrayList.add(propertySource);
        }
        return arrayList;
    }

    public static List<PropertySource<?>> getPropertySourcesWithoutPrefixes(MutablePropertySources mutablePropertySources, String[] stringArray) {
        ArrayList arrayList = new ArrayList();
        for (PropertySource propertySource : mutablePropertySources) {
            if (!(propertySource instanceof PropertiesPropertySource)) continue;
            PropertiesPropertySource propertiesPropertySource = (PropertiesPropertySource)propertySource;
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)((Map)propertiesPropertySource.getSource()));
            boolean bl = false;
            for (String string : stringArray) {
                if (!properties.containsKey(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(propertySource);
        }
        return arrayList;
    }

    public static Properties extractPropertiesWithPrefixes(Properties properties, String[] stringArray) {
        Properties properties2 = new Properties();
        for (String string : stringArray) {
            if (!properties.containsKey(string)) continue;
            properties2.setProperty(string, properties.getProperty(string));
        }
        return properties2;
    }

    public static void setSystemPropertiesWithMapping(Properties properties, String[] stringArray, Map<String, String> map) {
        for (String string : stringArray) {
            if (!properties.containsKey(string)) continue;
            String string2 = properties.getProperty(string);
            String string3 = map.get(string);
            if (string3 == null) continue;
            SystemPropertyUtils.setSystemProperty(string, string2, string3);
        }
    }

    public static void processYamlFiles(ConfigurableEnvironment configurableEnvironment, String[] stringArray, StandardPBEStringEncryptor standardPBEStringEncryptor) {
        try {
            PathMatchingResourcePatternResolver pathMatchingResourcePatternResolver = new PathMatchingResourcePatternResolver();
            for (String string : YAML_EXTENSIONS) {
                Resource[] resourceArray;
                for (Resource resource : resourceArray = pathMatchingResourcePatternResolver.getResources("classpath*:application*" + string)) {
                    if (!resource.exists()) continue;
                    JasyptNacosUtils.processYamlFile(resource, configurableEnvironment, stringArray, standardPBEStringEncryptor);
                }
            }
        }
        catch (IOException iOException) {
            log.error("\u5904\u7406YAML\u6587\u4ef6\u5931\u8d25", (Throwable)iOException);
            throw new IllegalStateException("\u5904\u7406YAML\u6587\u4ef6\u5931\u8d25", iOException);
        }
    }

    private static void processYamlFile(Resource resource, ConfigurableEnvironment configurableEnvironment, String[] stringArray, StandardPBEStringEncryptor standardPBEStringEncryptor) throws IOException {
        String string = StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        Yaml yaml = new Yaml();
        Iterable iterable = yaml.loadAll(string);
        Map<String, Object> map = JasyptMapUtils.newHashMap();
        for (Object object : iterable) {
            if (!(object instanceof Map)) continue;
            JasyptMapUtils.mergeMaps(map, (Map)object);
        }
        if (JasyptNacosUtils.containsProperties(map, stringArray)) {
            Object object;
            Properties properties = new Properties();
            JasyptMapUtils.flattenMap("", map, properties);
            object = new Properties();
            for (String string2 : stringArray) {
                if (!properties.containsKey(string2)) continue;
                ((Properties)object).setProperty(string2, properties.getProperty(string2));
            }
            if (!((Properties)object).isEmpty()) {
                Properties properties2 = JasyptUtils.decryptProperties((Properties)object, standardPBEStringEncryptor);
                for (String string3 : stringArray) {
                    if (!properties2.containsKey(string3)) continue;
                    String string4 = properties2.getProperty(string3);
                    JasyptMapUtils.setProperty(map, string3.split("\\."), string4);
                }
                Properties properties3 = new Properties();
                JasyptMapUtils.flattenMap("", map, properties3);
                PropertySource<?> propertySource = JasyptUtils.createDecryptedPropertySource("encrypted-" + resource.getFilename(), properties3, standardPBEStringEncryptor);
                configurableEnvironment.getPropertySources().addFirst(propertySource);
            }
        }
    }

    public static void processPropertySource(PropertySource<?> propertySource, ConfigurableEnvironment configurableEnvironment, String[] stringArray, StandardPBEStringEncryptor standardPBEStringEncryptor) {
        if (propertySource instanceof PropertiesPropertySource) {
            PropertiesPropertySource propertiesPropertySource = (PropertiesPropertySource)propertySource;
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)((Map)propertiesPropertySource.getSource()));
            Properties properties2 = new Properties();
            for (String string : stringArray) {
                if (!properties.containsKey(string)) continue;
                properties2.setProperty(string, properties.getProperty(string));
            }
            if (!properties2.isEmpty()) {
                Properties properties3 = JasyptUtils.decryptProperties(properties2, standardPBEStringEncryptor);
                PropertySource<?> propertySource2 = JasyptUtils.createDecryptedPropertySource("encrypted-" + propertySource.getName(), properties3, standardPBEStringEncryptor);
                configurableEnvironment.getPropertySources().replace(propertySource.getName(), propertySource2);
            }
        }
    }

    private static boolean containsProperties(Map<String, Object> map, String[] stringArray) {
        for (String string : stringArray) {
            if (!JasyptMapUtils.containsKey(map, string.split("\\."))) continue;
            return true;
        }
        return false;
    }
}

