/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.jasypt.util;

import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.iv.IvGenerator;
import org.jasypt.properties.EncryptableProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class JasyptUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JasyptUtils.class);
    private static final String DEFAULT_ALGORITHM = "PBEWITHHMACSHA512ANDAES_256";
    private static final String DEFAULT_IV_GENERATOR_CLASS = "org.jasypt.iv.RandomIvGenerator";

    public static StandardPBEStringEncryptor createEncryptor(String string) {
        return JasyptUtils.createEncryptor(string, DEFAULT_ALGORITHM, DEFAULT_IV_GENERATOR_CLASS);
    }

    public static StandardPBEStringEncryptor createEncryptor(String string, String string2, String string3) {
        if (!StringUtils.hasText((String)string)) {
            throw new IllegalArgumentException("\u52a0\u5bc6\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        StandardPBEStringEncryptor standardPBEStringEncryptor = new StandardPBEStringEncryptor();
        standardPBEStringEncryptor.setPassword(string);
        standardPBEStringEncryptor.setAlgorithm(string2);
        try {
            Class<?> clazz = Class.forName(string3);
            IvGenerator ivGenerator = (IvGenerator)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            standardPBEStringEncryptor.setIvGenerator(ivGenerator);
        }
        catch (Exception exception) {
            log.error("\u8bbe\u7f6eIV\u751f\u6210\u5668\u5931\u8d25: {}", (Object)string3, (Object)exception);
            throw new IllegalStateException("\u65e0\u6cd5\u8bbe\u7f6eIV\u751f\u6210\u5668: " + string3, exception);
        }
        return standardPBEStringEncryptor;
    }

    public static String encrypt(String string, StandardPBEStringEncryptor standardPBEStringEncryptor) {
        if (!StringUtils.hasText((String)string)) {
            return string;
        }
        return standardPBEStringEncryptor.encrypt(string);
    }

    public static String decrypt(String string, StandardPBEStringEncryptor standardPBEStringEncryptor) {
        if (!StringUtils.hasText((String)string)) {
            return string;
        }
        return standardPBEStringEncryptor.decrypt(string);
    }

    public static Properties encryptProperties(Properties properties, StandardPBEStringEncryptor standardPBEStringEncryptor) {
        if (properties == null || properties.isEmpty()) {
            return properties;
        }
        Properties properties2 = new Properties();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(object, object2) -> {
            if (object2 instanceof String) {
                properties2.setProperty((String)object, JasyptUtils.encrypt((String)object2, standardPBEStringEncryptor));
            } else {
                properties2.setProperty((String)object, String.valueOf(object2));
            }
        }));
        return properties2;
    }

    public static Properties decryptProperties(Properties properties, StandardPBEStringEncryptor standardPBEStringEncryptor) {
        if (properties == null || properties.isEmpty()) {
            return properties;
        }
        EncryptableProperties encryptableProperties = new EncryptableProperties(properties, (StringEncryptor)standardPBEStringEncryptor);
        Properties properties2 = new Properties();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(object, object2) -> {
            if (object2 instanceof String) {
                properties2.setProperty((String)object, encryptableProperties.getProperty((String)object));
            } else {
                properties2.setProperty((String)object, String.valueOf(object2));
            }
        }));
        return properties2;
    }

    public static PropertySource<?> createEncryptedPropertySource(String string, Properties properties, StandardPBEStringEncryptor standardPBEStringEncryptor) {
        Properties properties2 = JasyptUtils.encryptProperties(properties, standardPBEStringEncryptor);
        return new PropertiesPropertySource(string, properties2);
    }

    public static PropertySource<?> createDecryptedPropertySource(String string, Properties properties, StandardPBEStringEncryptor standardPBEStringEncryptor) {
        Properties properties2 = JasyptUtils.decryptProperties(properties, standardPBEStringEncryptor);
        return new PropertiesPropertySource(string, properties2);
    }

    public static StandardPBEStringEncryptor getEncryptorFromEnvironment(ConfigurableEnvironment configurableEnvironment) {
        if (Objects.isNull(configurableEnvironment)) {
            return null;
        }
        String string = configurableEnvironment.getProperty("jasypt.encryptor.password");
        if (!StringUtils.hasText((String)string)) {
            return null;
        }
        String string2 = configurableEnvironment.getProperty("jasypt.encryptor.algorithm", DEFAULT_ALGORITHM);
        String string3 = configurableEnvironment.getProperty("jasypt.encryptor.iv-generator-classname", DEFAULT_IV_GENERATOR_CLASS);
        return JasyptUtils.createEncryptor(string, string2, string3);
    }
}

