/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.quartz.config;

import com.lenovo.cloud.framework.quartz.config.XxlJobProperties;
import com.xxl.job.core.executor.XxlJobExecutor;
import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;

@AutoConfiguration
@ConditionalOnClass(value={XxlJobSpringExecutor.class})
@ConditionalOnProperty(prefix="xxl.job", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={XxlJobProperties.class})
@EnableScheduling
public class XxlJobAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XxlJobAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public XxlJobExecutor xxlJobExecutor(XxlJobProperties xxlJobProperties) {
        log.info("[xxlJobExecutor][\u521d\u59cb\u5316 XXL-Job \u6267\u884c\u5668\u7684\u914d\u7f6e]");
        XxlJobProperties.AdminProperties adminProperties = xxlJobProperties.getAdmin();
        XxlJobProperties.ExecutorProperties executorProperties = xxlJobProperties.getExecutor();
        XxlJobSpringExecutor xxlJobSpringExecutor = new XxlJobSpringExecutor();
        xxlJobSpringExecutor.setIp(executorProperties.getIp());
        xxlJobSpringExecutor.setPort(executorProperties.getPort().intValue());
        xxlJobSpringExecutor.setAppname(executorProperties.getAppName());
        xxlJobSpringExecutor.setLogPath(executorProperties.getLogPath());
        xxlJobSpringExecutor.setLogRetentionDays(executorProperties.getLogRetentionDays().intValue());
        xxlJobSpringExecutor.setAdminAddresses(adminProperties.getAddresses());
        xxlJobSpringExecutor.setAccessToken(xxlJobProperties.getAccessToken());
        return xxlJobSpringExecutor;
    }
}

