/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.log.config;

import com.lenovo.cloud.framework.log.config.LogProperties;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.io.ClassPathResource;

@org.springframework.context.annotation.Configuration
@EnableConfigurationProperties(value={LogProperties.class})
public class Log4j2Configuration {
    private static final Logger logger = LoggerFactory.getLogger(Log4j2Configuration.class);
    private static final Lock configLock = new ReentrantLock();
    private static final String CONFIG_FILE = "log4j2-spring.xml";
    @Autowired
    private LogProperties logProperties;

    @PostConstruct
    public void init() {
        configLock.lock();
        try {
            LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
            this.setSystemProperties();
            this.loadConfiguration(loggerContext);
            loggerContext.updateLoggers();
            logger.info("Log4j2 configuration initialized successfully");
        }
        catch (Exception exception) {
            logger.error("Failed to initialize Log4j2 configuration", (Throwable)exception);
            this.ensureBasicLogging();
        }
        finally {
            configLock.unlock();
        }
    }

    private void setSystemProperties() {
        try {
            System.setProperty("lenovo.log.clientIp", this.logProperties.getClientIp());
            System.setProperty("lenovo.log.instanceName", this.logProperties.getInstanceName());
            logger.debug("System properties set successfully");
        }
        catch (Exception exception) {
            logger.error("Failed to set system properties", (Throwable)exception);
            throw new RuntimeException("Failed to set system properties", exception);
        }
    }

    private void loadConfiguration(LoggerContext loggerContext) throws IOException {
        ClassPathResource classPathResource = new ClassPathResource(CONFIG_FILE);
        if (!classPathResource.exists()) {
            logger.warn("Log4j2 configuration file not found: {}", (Object)CONFIG_FILE);
            DefaultConfiguration defaultConfiguration = new DefaultConfiguration();
            loggerContext.start((Configuration)defaultConfiguration);
            return;
        }
        try (InputStream inputStream = classPathResource.getInputStream();){
            Configurator.reconfigure((URI)classPathResource.getURL().toURI());
            logger.debug("Log4j2 configuration loaded successfully from: {}", (Object)CONFIG_FILE);
        }
        catch (Exception exception) {
            logger.error("Failed to load Log4j2 configuration from: {}", (Object)CONFIG_FILE, (Object)exception);
            throw new IOException("Failed to load Log4j2 configuration", exception);
        }
    }

    private void ensureBasicLogging() {
        try {
            LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
            DefaultConfiguration defaultConfiguration = new DefaultConfiguration();
            loggerContext.start((Configuration)defaultConfiguration);
            loggerContext.updateLoggers();
            logger.warn("Using default Log4j2 configuration due to initialization failure");
        }
        catch (Exception exception) {
            logger.error("Failed to initialize basic logging configuration", (Throwable)exception);
        }
    }

    public void updateConfiguration() {
        configLock.lock();
        try {
            LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
            this.setSystemProperties();
            this.loadConfiguration(loggerContext);
            loggerContext.updateLoggers();
            logger.info("Log4j2 configuration updated successfully");
        }
        catch (Exception exception) {
            logger.error("Failed to update Log4j2 configuration", (Throwable)exception);
        }
        finally {
            configLock.unlock();
        }
    }
}

