/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.log.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class LogContextUtil {
    private static final Logger logger = LoggerFactory.getLogger(LogContextUtil.class);
    private static final String INSTANCE_NAME_KEY = "instanceName";
    private static final String CLIENT_IP_KEY = "clientIp";

    public static void initLogContext() {
        try {
            String string;
            String string2 = LogContextUtil.getInstanceName();
            if (StringUtils.hasText((String)string2)) {
                ThreadContext.put((String)INSTANCE_NAME_KEY, (String)string2);
            }
            if (StringUtils.hasText((String)(string = LogContextUtil.getLocalIp()))) {
                ThreadContext.put((String)CLIENT_IP_KEY, (String)string);
            }
            logger.info("Log context initialized - Instance: {}, IP: {}", (Object)string2, (Object)string);
        }
        catch (Exception exception) {
            logger.error("Failed to initialize log context", (Throwable)exception);
        }
    }

    private static String getInstanceName() {
        try {
            String string = System.getProperty("spring.application.name");
            if (!StringUtils.hasText((String)string)) {
                string = System.getProperty("app.name");
            }
            return StringUtils.hasText((String)string) ? string : "unknown";
        }
        catch (Exception exception) {
            logger.warn("Failed to get instance name", (Throwable)exception);
            return "unknown";
        }
    }

    private static String getLocalIp() {
        try {
            String string = System.getProperty("app.ip");
            if (StringUtils.hasText((String)string)) {
                return string;
            }
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface.isLoopback() || networkInterface.isVirtual() || !networkInterface.isUp()) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress() || !inetAddress.isSiteLocalAddress()) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (Exception exception) {
            logger.warn("Failed to get local IP", (Throwable)exception);
        }
        return "unknown";
    }

    public static void clearLogContext() {
        try {
            ThreadContext.remove((String)INSTANCE_NAME_KEY);
            ThreadContext.remove((String)CLIENT_IP_KEY);
        }
        catch (Exception exception) {
            logger.warn("Failed to clear log context", (Throwable)exception);
        }
    }
}

