/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.log.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.regex.Pattern;

public class NetworkUtils {
    private static final Pattern IP_PATTERN = Pattern.compile("^((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$");

    public static String getLocalIp() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            Object var1_2 = null;
            String string = null;
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (networkInterface.isLoopback() || networkInterface.isVirtual() || !networkInterface.isUp()) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    String string2 = inetAddress.getHostAddress();
                    if (string2.contains(":") || !IP_PATTERN.matcher(string2).matches()) continue;
                    if (NetworkUtils.isInnerIp(string2)) {
                        string = string2;
                        continue;
                    }
                    return string2;
                }
            }
            return string != null ? string : "127.0.0.1";
        }
        catch (SocketException socketException) {
            return "127.0.0.1";
        }
    }

    private static boolean isInnerIp(String string) {
        return string.startsWith("10.") || string.startsWith("172.16.") || string.startsWith("172.17.") || string.startsWith("172.18.") || string.startsWith("172.19.") || string.startsWith("172.20.") || string.startsWith("172.21.") || string.startsWith("172.22.") || string.startsWith("172.23.") || string.startsWith("172.24.") || string.startsWith("172.25.") || string.startsWith("172.26.") || string.startsWith("172.27.") || string.startsWith("172.28.") || string.startsWith("172.29.") || string.startsWith("172.30.") || string.startsWith("172.31.") || string.startsWith("192.168.");
    }
}

