/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.mail.core.aop;

import com.lenovo.cloud.framework.mail.core.biz.MailLogBiz;
import com.lenovo.cloud.framework.mail.core.request.JavaMailClientReq;
import jakarta.annotation.Resource;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

@Configuration
@Aspect
@ConditionalOnProperty(prefix="mail.log.storage", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class MailLogStorageAspect {
    private static Logger log = LoggerFactory.getLogger(MailLogStorageAspect.class);
    @Resource
    MailLogBiz mailLogBiz;
    private final String ADD_POINT_CUT = " (execution(* com.lenovo.cloud.framework.mail.core.handler..*.*(..))&& args(javaMailClientReq))";

    @Before(value="saveSendMailLog(javaMailClientReq)")
    public void sendSmsLogCall(JavaMailClientReq javaMailClientReq) {
        log.debug("send sms log ! javaMailClientReq:{}", (Object)javaMailClientReq);
        try {
            this.mailLogBiz.saveSendMailLog(javaMailClientReq);
        }
        catch (Exception exception) {
            log.error("\u4fdd\u5b58\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38", (Throwable)exception);
        }
    }

    @Pointcut(value=" (execution(* com.lenovo.cloud.framework.mail.core.handler..*.*(..))&& args(javaMailClientReq))")
    public void saveSendMailLog(JavaMailClientReq javaMailClientReq) {
    }
}

