/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.mail.core.biz.impl;

import com.lenovo.cloud.framework.common.request.BaseRequest;
import com.lenovo.cloud.framework.common.response.BaseResponse;
import com.lenovo.cloud.framework.mail.core.biz.MailSendBiz;
import com.lenovo.cloud.framework.mail.core.enums.MailBodyType;
import com.lenovo.cloud.framework.mail.core.enums.MailPlatformType;
import com.lenovo.cloud.framework.mail.core.handler.AbstractMailHandler;
import com.lenovo.cloud.framework.mail.core.handler.MailHandlerContext;
import com.lenovo.cloud.framework.mail.core.properties.MailPlatformProperties;
import com.lenovo.cloud.framework.mail.core.request.JavaMailClientReq;
import com.lenovo.cloud.framework.mail.core.request.MailMeetingReq;
import com.lenovo.cloud.framework.mail.core.request.MailSendReq;
import com.lenovo.cloud.framework.mail.core.response.MeetingResp;
import jakarta.annotation.Resource;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class MailSendBizImpl
implements MailSendBiz {
    private static Logger log = LoggerFactory.getLogger(MailSendBizImpl.class);
    @Resource
    MailHandlerContext mailHandlerContext;
    @Resource
    MailPlatformProperties mailPlatformProperties;

    @Override
    public boolean sendSimpleMail(String string, String string2, String string3) {
        BaseRequest baseRequest = new BaseRequest();
        MailSendReq mailSendReq = MailSendReq.builder().subject(string2).content(string3).recipientTos(Arrays.asList(string)).mailBodyType(MailBodyType.Text).build();
        baseRequest.setData((Object)mailSendReq);
        return this.sendMailByMailSendReq((BaseRequest<MailSendReq>)baseRequest);
    }

    @Override
    public boolean sendHtmlMail(String string, String string2, String string3) {
        BaseRequest baseRequest = new BaseRequest();
        MailSendReq mailSendReq = MailSendReq.builder().subject(string2).content(string3).recipientTos(Arrays.asList(string)).mailBodyType(MailBodyType.HTML).build();
        baseRequest.setData((Object)mailSendReq);
        return this.sendMailByMailSendReq((BaseRequest<MailSendReq>)baseRequest);
    }

    @Override
    public boolean sendMail(BaseRequest<MailSendReq> baseRequest) {
        return this.sendMailByMailSendReq(baseRequest);
    }

    private boolean sendMailByMailSendReq(BaseRequest<MailSendReq> baseRequest) {
        try {
            this.checkMailSendReq(baseRequest);
            AbstractMailHandler abstractMailHandler = this.getAbstractMailHandler();
            JavaMailClientReq javaMailClientReq = this.getJavaMailClientReq(baseRequest);
            return abstractMailHandler.send((BaseRequest<JavaMailClientReq>)BaseRequest.simple((Object)javaMailClientReq)).isSuccess();
        }
        catch (Exception exception) {
            log.error("\u53d1\u9001\u90ae\u4ef6\u5f02\u5e38", (Throwable)exception);
            return false;
        }
    }

    private JavaMailClientReq getJavaMailClientReq(BaseRequest<MailSendReq> baseRequest) {
        MailSendReq mailSendReq = (MailSendReq)baseRequest.getData();
        MailBodyType mailBodyType = MailBodyType.Text;
        if (!Objects.isNull((Object)mailSendReq.getMailBodyType())) {
            mailBodyType = mailSendReq.getMailBodyType();
        }
        JavaMailClientReq javaMailClientReq = JavaMailClientReq.builder().subject(mailSendReq.getSubject()).content(mailSendReq.getContent()).recipientTos(mailSendReq.getRecipientTos()).recipientCc(mailSendReq.getRecipientCc()).recipientBcc(mailSendReq.getRecipientBcc()).attachments(mailSendReq.getFiles()).images(mailSendReq.getImages()).mailBodyType(mailBodyType).mailPlatformType(this.getMailPlatformType().getType()).importance(mailSendReq.getImportance()).accountId(mailSendReq.getAccountId()).nickname(mailSendReq.getNickname()).build();
        return javaMailClientReq;
    }

    private void checkMailSendReq(BaseRequest<MailSendReq> baseRequest) {
        AtomicBoolean atomicBoolean;
        Assert.notNull(baseRequest, (String)"\u90ae\u4ef6\u53d1\u9001\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)baseRequest.getData(), (String)"\u90ae\u4ef6\u53d1\u9001\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty(((MailSendReq)baseRequest.getData()).getRecipientTos(), (String)"\u6536\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        if (!CollectionUtils.isEmpty(((MailSendReq)baseRequest.getData()).getImages())) {
            atomicBoolean = new AtomicBoolean(false);
            ((MailSendReq)baseRequest.getData()).getImages().parallelStream().forEach(mailImageReq -> {
                boolean bl;
                boolean bl2 = bl = !StringUtils.hasLength((String)mailImageReq.getBase64Str()) && (null == mailImageReq.getData() || mailImageReq.getData().length == 0);
                if (bl) {
                    atomicBoolean.set(true);
                }
            });
            if (atomicBoolean.get()) {
                throw new IllegalArgumentException("\u90ae\u4ef6\u56fe\u7247\u4fe1\u606f\u5b58\u5728\u7a7a");
            }
        }
        if (!CollectionUtils.isEmpty(((MailSendReq)baseRequest.getData()).getFiles())) {
            atomicBoolean = new AtomicBoolean(false);
            ((MailSendReq)baseRequest.getData()).getFiles().parallelStream().forEach(mailFileReq -> {
                boolean bl;
                boolean bl2 = bl = !StringUtils.hasLength((String)mailFileReq.getBase64Str()) && (null == mailFileReq.getData() || mailFileReq.getData().length == 0);
                if (bl) {
                    atomicBoolean.set(true);
                }
            });
            if (atomicBoolean.get()) {
                throw new IllegalArgumentException("\u90ae\u4ef6\u9644\u4ef6\u4fe1\u606f\u5b58\u5728\u7a7a");
            }
        }
    }

    @Override
    public boolean batchSendMail(BaseRequest<List<MailSendReq>> baseRequest) {
        Assert.notNull(baseRequest, (String)"\u90ae\u4ef6\u53d1\u9001\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)((Collection)baseRequest.getData()), (String)"\u90ae\u4ef6\u53d1\u9001\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            List list = (List)baseRequest.getData();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                list.parallelStream().forEach(mailSendReq -> this.sendMail((BaseRequest<MailSendReq>)BaseRequest.simple((Object)mailSendReq)));
            }
        }
        catch (Exception exception) {
            log.error("\u53d1\u9001\u90ae\u4ef6\u5f02\u5e38", (Throwable)exception);
            return false;
        }
        return true;
    }

    private void checkRecipientTo(String string) {
        Assert.notNull((Object)string, (String)"\u6536\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private AbstractMailHandler getAbstractMailHandler() {
        return (AbstractMailHandler)this.mailHandlerContext.getInstance(this.getMailPlatformType());
    }

    private MailPlatformType getMailPlatformType() {
        String string = this.mailPlatformProperties.getType();
        MailPlatformType mailPlatformType = MailPlatformType.MOCK;
        if (StringUtils.hasLength((String)string) && !Objects.isNull((Object)MailPlatformType.mailPlatformTypeMap.get(string))) {
            mailPlatformType = MailPlatformType.mailPlatformTypeMap.get(string);
        }
        return mailPlatformType;
    }

    @Override
    public BaseResponse<String> mailSend(BaseRequest<MailSendReq> baseRequest) {
        try {
            this.checkMailSendReq(baseRequest);
            BaseRequest baseRequest2 = new BaseRequest();
            baseRequest2.requestId(baseRequest.getRequestId());
            AbstractMailHandler abstractMailHandler = this.getAbstractMailHandler();
            JavaMailClientReq javaMailClientReq = this.getJavaMailClientReq(baseRequest);
            baseRequest2.data((Object)javaMailClientReq);
            return abstractMailHandler.send((BaseRequest<JavaMailClientReq>)baseRequest2);
        }
        catch (Exception exception) {
            log.error("\u53d1\u9001\u90ae\u4ef6\u5f02\u5e38", (Throwable)exception);
            BaseResponse baseResponse = BaseResponse.error();
            baseResponse.setMessage(exception.getMessage());
            baseResponse.setResponseId(baseRequest.getRequestId());
            return baseResponse;
        }
    }

    @Override
    public BaseResponse<MeetingResp> meeting(BaseRequest<MailMeetingReq> baseRequest) {
        try {
            this.checkMailMeetingReq(baseRequest);
            AbstractMailHandler abstractMailHandler = this.getAbstractMailHandler();
            return abstractMailHandler.meeting(baseRequest);
        }
        catch (Exception exception) {
            log.error("\u53d1\u9001\u4f1a\u8bae\u5f02\u5e38", (Throwable)exception);
            MeetingResp meetingResp = MeetingResp.builder().responseId(baseRequest.getRequestId()).errorMessage(exception.getMessage()).build();
            return BaseResponse.error((Object)meetingResp);
        }
    }

    private void checkMailMeetingReq(BaseRequest<MailMeetingReq> baseRequest) {
        Assert.notNull(baseRequest, (String)"\u90ae\u4ef6\u4f1a\u8bae\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)baseRequest.getData(), (String)"\u90ae\u4ef6\u4f1a\u8bae\u8bf7\u6c42\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty(((MailMeetingReq)baseRequest.getData()).getAttendees(), (String)"\u6536\u4ef6\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)((MailMeetingReq)baseRequest.getData()).getStartTime(), (String)"\u4f1a\u8bae\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)((MailMeetingReq)baseRequest.getData()).getEndTime(), (String)"\u4f1a\u8bae\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

