/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.mail.core.handler;

import com.google.common.collect.Maps;
import com.lenovo.cloud.framework.common.spring.utils.content.ClassResourceLoaderAware;
import com.lenovo.cloud.framework.mail.core.enums.MailPlatformType;
import com.lenovo.cloud.framework.mail.core.handler.MailHandlerContext;
import com.lenovo.cloud.framework.mail.core.handler.annotation.MailHandlerType;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.stereotype.Component;

@Component
public class MailHandlerProcessor
implements BeanFactoryPostProcessor {
    private static final String HANDLER_PACKAGE = "com.lenovo.cloud.framework.mail.core.handler";

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        ConcurrentMap concurrentMap = Maps.newConcurrentMap();
        ClassResourceLoaderAware.scan((String)HANDLER_PACKAGE, (Class[])new Class[]{MailHandlerType.class}).forEach(clazz -> {
            MailPlatformType mailPlatformType = clazz.getAnnotation(MailHandlerType.class).value();
            concurrentMap.put(mailPlatformType, clazz);
        });
        MailHandlerContext mailHandlerContext = new MailHandlerContext(concurrentMap);
        configurableListableBeanFactory.registerSingleton(MailHandlerContext.class.getName(), (Object)mailHandlerContext);
    }
}

