/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.mail.core.config;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.lenovo.cloud.framework.mail.core.properties.MicrosoftAzureProperties;
import com.microsoft.graph.serviceclient.GraphServiceClient;
import jakarta.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.Assert;

@Configuration
public class GraphClientConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphClientConfig.class);
    @Resource
    private MicrosoftAzureProperties microsoftAzureProperties;

    @Bean(name={"graphClient"})
    public GraphServiceClient graphServiceClient() {
        log.info("Initializing Microsoft Graph Beta client");
        String string = this.microsoftAzureProperties.getClientId();
        String string2 = this.microsoftAzureProperties.getTenantId();
        String string3 = this.microsoftAzureProperties.getClientSecret();
        String[] stringArray = new String[]{"https://graph.microsoft.com/.default"};
        ClientSecretCredential clientSecretCredential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(string)).tenantId(string2)).clientSecret(string3).build();
        if (null == stringArray || null == clientSecretCredential) {
            log.error("Failed to initialize Microsoft Graph Beta client");
            Assert.notNull((Object)stringArray, (String)"Failed to initialize Microsoft Graph Beta client");
            Assert.notNull((Object)clientSecretCredential, (String)"Failed to initialize Microsoft Graph Beta client");
        }
        GraphServiceClient graphServiceClient = new GraphServiceClient((TokenCredential)clientSecretCredential, stringArray);
        return graphServiceClient;
    }
}

